/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.RRectKt;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skia/RRect;", "Lorg/jetbrains/skia/Rect;", "l", "", "t", "r", "b", "radii", "", "<init>", "(FFFF[F)V", "getRadii", "()[F", "inflate", "spread", "toString", "", "equals", "", "other", "", "hashCode", "", "Companion", "skiko"})
public final class RRect
extends Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] radii;

    public RRect(float l, float t, float r, float b, @NotNull float[] radii) {
        Intrinsics.checkNotNullParameter((Object)radii, (String)"radii");
        super(l, t, r, b);
        this.radii = radii;
    }

    @NotNull
    public final float[] getRadii() {
        return this.radii;
    }

    @Override
    @NotNull
    public Rect inflate(float spread) {
        Rect rect;
        boolean becomesRect = true;
        int n = this.radii.length;
        for (int i = 0; i < n; ++i) {
            if (!(this.radii[i] + spread >= 0.0f)) continue;
            becomesRect = false;
            break;
        }
        if (becomesRect) {
            rect = Rect.Companion.makeLTRB(this.getLeft() - spread, this.getTop() - spread, Math.max(this.getLeft() - spread, this.getRight() + spread), Math.max(this.getTop() - spread, this.getBottom() + spread));
        } else {
            float[] fArray = Arrays.copyOf(this.radii, this.radii.length);
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
            float[] radii = fArray;
            int n2 = radii.length;
            for (int i = 0; i < n2; ++i) {
                radii[i] = Math.max(0.0f, radii[i] + spread);
            }
            rect = new RRect(this.getLeft() - spread, this.getTop() - spread, Math.max(this.getLeft() - spread, this.getRight() + spread), Math.max(this.getTop() - spread, this.getBottom() + spread), radii);
        }
        return rect;
    }

    @Override
    @NotNull
    public String toString() {
        return "RRect(_left=" + this.getLeft() + ", _top=" + this.getTop() + ", _right=" + this.getRight() + ", _bottom=" + this.getBottom() + ", _radii=" + ArraysKt.joinToString$default((float[])this.radii, null, null, null, (int)0, null, null, (int)63, null) + ')';
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RRect)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.radii.length == ((RRect)other).radii.length ? Arrays.equals(this.radii, ((RRect)other).radii) : Arrays.equals(RRectKt.access$normalizeRadii(this.radii), RRectKt.access$normalizeRadii(((RRect)other).radii));
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * PRIME + Arrays.hashCode(this.radii);
        return result;
    }

    @JvmStatic
    @NotNull
    public static final RRect makeLTRB(float l, float t, float r, float b, float radius) {
        return Companion.makeLTRB(l, t, r, b, radius);
    }

    @JvmStatic
    @NotNull
    public static final RRect makeLTRB(float l, float t, float r, float b, float xRad, float yRad) {
        return Companion.makeLTRB(l, t, r, b, xRad, yRad);
    }

    @JvmStatic
    @NotNull
    public static final RRect makeLTRB(float l, float t, float r, float b, float tlRad, float trRad, float brRad, float blRad) {
        return Companion.makeLTRB(l, t, r, b, tlRad, trRad, brRad, blRad);
    }

    @JvmStatic
    @NotNull
    public static final RRect makeNinePatchLTRB(float l, float t, float r, float b, float lRad, float tRad, float rRad, float bRad) {
        return Companion.makeNinePatchLTRB(l, t, r, b, lRad, tRad, rRad, bRad);
    }

    @JvmStatic
    @NotNull
    public static final RRect makeComplexLTRB(float l, float t, float r, float b, @NotNull float[] radii) {
        return Companion.makeComplexLTRB(l, t, r, b, radii);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0014\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0007J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0007JH\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0007JH\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0007J0\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J&\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J&\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J.\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J6\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007JF\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007JF\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007J.\u0010 \u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J&\u0010\"\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J0\u0010#\u001a\u00020\u00052!\u0010$\u001a\u001d\u0012\u0004\u0012\u00020&\u0012\b\u0012\u00060(j\u0002`'\u0012\u0004\u0012\u00020)0%\u00a2\u0006\u0002\b*H\u0000\u00a2\u0006\u0002\b+J'\u0010,\u001a\u0004\u0018\u00010\u00052\u0016\u0010$\u001a\u0012\u0012\b\u0012\u00060(j\u0002`'\u0012\u0004\u0012\u00020.0-H\u0000\u00a2\u0006\u0002\b/\u00a8\u00060"}, d2={"Lorg/jetbrains/skia/RRect$Companion;", "", "<init>", "()V", "makeLTRB", "Lorg/jetbrains/skia/RRect;", "l", "", "t", "r", "b", "radius", "xRad", "yRad", "tlRad", "trRad", "brRad", "blRad", "makeNinePatchLTRB", "lRad", "tRad", "rRad", "bRad", "makeComplexLTRB", "radii", "", "makeOvalLTRB", "makePillLTRB", "makeXYWH", "w", "h", "makeNinePatchXYWH", "makeComplexXYWH", "makeOvalXYWH", "makePillXYWH", "fromInteropPointer", "block", "Lkotlin/Function2;", "Lorg/jetbrains/skia/impl/InteropScope;", "Lorg/jetbrains/skia/impl/InteropPointer;", "Ljava/lang/Object;", "", "Lkotlin/ExtensionFunctionType;", "fromInteropPointer$skiko", "fromInteropPointerNullable", "Lkotlin/Function1;", "", "fromInteropPointerNullable$skiko", "skiko"})
    @SourceDebugExtension(value={"SMAP\nRRect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RRect.kt\norg/jetbrains/skia/RRect$Companion\n+ 2 Native.kt\norg/jetbrains/skia/impl/NativeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n*L\n1#1,179:1\n96#2:180\n97#2,5:182\n55#3:181\n*S KotlinDebug\n*F\n+ 1 RRect.kt\norg/jetbrains/skia/RRect$Companion\n*L\n158#1:180\n158#1:182,5\n158#1:181\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RRect makeLTRB(float l, float t, float r, float b, float radius) {
            float[] fArray = new float[]{radius};
            return new RRect(l, t, r, b, fArray);
        }

        @JvmStatic
        @NotNull
        public final RRect makeLTRB(float l, float t, float r, float b, float xRad, float yRad) {
            float[] fArray = new float[]{xRad, yRad};
            return new RRect(l, t, r, b, fArray);
        }

        @JvmStatic
        @NotNull
        public final RRect makeLTRB(float l, float t, float r, float b, float tlRad, float trRad, float brRad, float blRad) {
            float[] fArray = new float[]{tlRad, trRad, brRad, blRad};
            return new RRect(l, t, r, b, fArray);
        }

        @JvmStatic
        @NotNull
        public final RRect makeNinePatchLTRB(float l, float t, float r, float b, float lRad, float tRad, float rRad, float bRad) {
            float[] fArray = new float[]{lRad, tRad, rRad, tRad, rRad, bRad, lRad, bRad};
            return new RRect(l, t, r, b, fArray);
        }

        @JvmStatic
        @NotNull
        public final RRect makeComplexLTRB(float l, float t, float r, float b, @NotNull float[] radii) {
            Intrinsics.checkNotNullParameter((Object)radii, (String)"radii");
            return new RRect(l, t, r, b, radii);
        }

        @NotNull
        public final RRect makeOvalLTRB(float l, float t, float r, float b) {
            float[] fArray = new float[]{Math.abs(r - l) / 2.0f, Math.abs(b - t) / 2.0f};
            return new RRect(l, t, r, b, fArray);
        }

        @NotNull
        public final RRect makePillLTRB(float l, float t, float r, float b) {
            float[] fArray = new float[]{Math.min(Math.abs(r - l), Math.abs(t - b)) / 2.0f};
            return new RRect(l, t, r, b, fArray);
        }

        @NotNull
        public final RRect makeXYWH(float l, float t, float w, float h, float radius) {
            float[] fArray = new float[]{radius};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect makeXYWH(float l, float t, float w, float h, float xRad, float yRad) {
            float[] fArray = new float[]{xRad, yRad};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect makeXYWH(float l, float t, float w, float h, float tlRad, float trRad, float brRad, float blRad) {
            float[] fArray = new float[]{tlRad, trRad, brRad, blRad};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect makeNinePatchXYWH(float l, float t, float w, float h, float lRad, float tRad, float rRad, float bRad) {
            float[] fArray = new float[]{lRad, tRad, rRad, tRad, rRad, bRad, lRad, bRad};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect makeComplexXYWH(float l, float t, float w, float h, @NotNull float[] radii) {
            Intrinsics.checkNotNullParameter((Object)radii, (String)"radii");
            return new RRect(l, t, l + w, t + h, radii);
        }

        @NotNull
        public final RRect makeOvalXYWH(float l, float t, float w, float h) {
            float[] fArray = new float[]{w / 2.0f, h / 2.0f};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect makePillXYWH(float l, float t, float w, float h) {
            float[] fArray = new float[]{Math.min(w, h) / 2.0f};
            return new RRect(l, t, l + w, t + h, fArray);
        }

        @NotNull
        public final RRect fromInteropPointer$skiko(@NotNull Function2<? super InteropScope, ? super Object, Unit> block) {
            float[] result;
            Intrinsics.checkNotNullParameter(block, (String)"block");
            float[] result$iv = new float[12];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope = false;
            InteropScope $this$withResult_u24lambda_u242$iv = theScope.INSTANCE;
            boolean bl = false;
            Object handle$iv = $this$withResult_u24lambda_u242$iv.toInteropForResult(result$iv);
            block.invoke((Object)$this$withResult_u24lambda_u242$iv, handle$iv);
            $this$withResult_u24lambda_u242$iv.fromInterop(handle$iv, result$iv);
            float[] fArray = result = result$iv;
            int n = 4;
            int n2 = 12;
            return new RRect(result[0], result[1], result[2], result[3], ArraysKt.copyOfRange((float[])fArray, (int)n, (int)n2));
        }

        @Nullable
        public final RRect fromInteropPointerNullable$skiko(@NotNull Function1<? super Object, Boolean> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            Ref.BooleanRef result = new Ref.BooleanRef();
            result.element = true;
            RRect rect = this.fromInteropPointer$skiko((Function2<? super InteropScope, ? super Object, Unit>)((Function2)(arg_0, arg_1) -> Companion.fromInteropPointerNullable$lambda$0(result, block, arg_0, arg_1)));
            return result.element ? rect : null;
        }

        private static final Unit fromInteropPointerNullable$lambda$0(Ref.BooleanRef $result, Function1 $block, InteropScope $this$fromInteropPointer, Object it) {
            Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            Intrinsics.checkNotNullParameter((Object)$this$fromInteropPointer, (String)"$this$fromInteropPointer");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $result.element = (Boolean)$block.invoke(it);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

