/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.CssRenderKt;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.SRGB;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.internal.ParsingKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.terminal.TerminalRecorder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a#\u0010\b\u001a\u00020\t*\u00060\u000bj\u0002`\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\r*\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u0001H\u0002\u00a8\u0006\u0013"}, d2={"outputAsHtml", "", "Lcom/github/ajalt/mordant/terminal/TerminalRecorder;", "includeBodyTag", "", "includeCodeTag", "backgroundColor", "Lcom/github/ajalt/colormath/Color;", "addSpansAsHtml", "", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "spans", "", "Lcom/github/ajalt/mordant/rendering/Span;", "(Ljava/lang/StringBuilder;Ljava/util/List;)V", "asCssRules", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "escapeHtml", "mordant"})
@SourceDebugExtension(value={"SMAP\nHtmlRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlRenderer.kt\ncom/github/ajalt/mordant/terminal/HtmlRendererKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class HtmlRendererKt {
    @NotNull
    public static final String outputAsHtml(@NotNull TerminalRecorder $this$outputAsHtml, boolean includeBodyTag, boolean includeCodeTag, @Nullable Color backgroundColor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$outputAsHtml, (String)"<this>");
        StringBuilder $this$outputAsHtml_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Lines lines = ParsingKt.parseText($this$outputAsHtml.output(), ConstantsKt.getDEFAULT_STYLE());
        if (includeBodyTag) {
            StringBuilder stringBuilder2 = $this$outputAsHtml_u24lambda_u241.append("<html><body>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        }
        if (backgroundColor != null) {
            $this$outputAsHtml_u24lambda_u241.append("<div style=\"");
            $this$outputAsHtml_u24lambda_u241.append("border-radius: 8px;");
            $this$outputAsHtml_u24lambda_u241.append("width: fit-content;");
            $this$outputAsHtml_u24lambda_u241.append("padding: 0.5em 1em;");
            $this$outputAsHtml_u24lambda_u241.append("filter: drop-shadow(0.5em 0.5em 0.5em black);");
            $this$outputAsHtml_u24lambda_u241.append("background-color: " + CssRenderKt.formatCssString$default((Color)backgroundColor, null, null, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (int)127, null) + ';');
            $this$outputAsHtml_u24lambda_u241.append("\">");
            $this$outputAsHtml_u24lambda_u241.append("<div style=\"margin: -0.75em 0px;font-size: 2em\">");
            Object[] objectArray = new RGB[]{SRGB.INSTANCE.invoke("#ff5f56"), SRGB.INSTANCE.invoke("#ffbd2e"), SRGB.INSTANCE.invoke("#27c93f")};
            for (RGB color : CollectionsKt.listOf((Object[])objectArray)) {
                $this$outputAsHtml_u24lambda_u241.append("<span style=\"color: " + RGB.toHex$default((RGB)color, (boolean)false, null, (int)3, null) + ";\">\u23fa&nbsp;</span>");
            }
            StringBuilder stringBuilder3 = $this$outputAsHtml_u24lambda_u241.append("</div>");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        $this$outputAsHtml_u24lambda_u241.append("<pre style=\"font-family: monospace\">");
        if (includeCodeTag) {
            $this$outputAsHtml_u24lambda_u241.append("<code>");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$outputAsHtml_u24lambda_u241.append('\n'), (String)"append(...)");
        for (Line line : lines.getLines()) {
            List collected = new ArrayList();
            for (Span span : line) {
                boolean bl2;
                if ((Span)CollectionsKt.lastOrNull((List)collected) != null) {
                    Span it;
                    boolean bl3 = false;
                    bl2 = !Intrinsics.areEqual((Object)it.getStyle(), (Object)span.getStyle());
                } else {
                    bl2 = false;
                }
                if (bl2) {
                    HtmlRendererKt.addSpansAsHtml($this$outputAsHtml_u24lambda_u241, collected);
                    collected.clear();
                }
                collected.add(span);
            }
            HtmlRendererKt.addSpansAsHtml($this$outputAsHtml_u24lambda_u241, collected);
            Intrinsics.checkNotNullExpressionValue((Object)$this$outputAsHtml_u24lambda_u241.append('\n'), (String)"append(...)");
        }
        if (includeCodeTag) {
            $this$outputAsHtml_u24lambda_u241.append("</code>");
        }
        $this$outputAsHtml_u24lambda_u241.append("</pre>");
        if (backgroundColor != null) {
            $this$outputAsHtml_u24lambda_u241.append("\n</div>");
        }
        if (includeBodyTag) {
            $this$outputAsHtml_u24lambda_u241.append("\n</body></html>");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String outputAsHtml$default(TerminalRecorder terminalRecorder, boolean bl, boolean bl2, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            color = (Color)SRGB.INSTANCE.invoke("#0c0c0c");
        }
        return HtmlRendererKt.outputAsHtml(terminalRecorder, bl, bl2, color);
    }

    private static final void addSpansAsHtml(StringBuilder $this$addSpansAsHtml, List<Span> spans) {
        if (spans.isEmpty()) {
            return;
        }
        TextStyle style = ((Span)CollectionsKt.last(spans)).getStyle();
        String href = style.getHyperlink();
        StringBuilder stringBuilder = href != null ? $this$addSpansAsHtml.append("<a href=\"").append(href).append('\"') : $this$addSpansAsHtml.append("<span");
        List<String> rules = HtmlRendererKt.asCssRules(style);
        if (!((Collection)rules).isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)rules, (Appendable)$this$addSpansAsHtml, (CharSequence)"; ", (CharSequence)" style=\"", (CharSequence)"\"", (int)0, null, null, (int)112, null);
        }
        $this$addSpansAsHtml.append(">");
        CollectionsKt.joinTo$default((Iterable)spans, (Appendable)$this$addSpansAsHtml, (CharSequence)"", null, null, (int)0, null, HtmlRendererKt::addSpansAsHtml$lambda$2, (int)60, null);
        $this$addSpansAsHtml.append("</span>");
    }

    private static final List<String> asCssRules(TextStyle $this$asCssRules) {
        Color it;
        List rules = new ArrayList();
        Pair pair = Intrinsics.areEqual((Object)$this$asCssRules.getInverse(), (Object)true) ? TuplesKt.to((Object)$this$asCssRules.getBgColor(), (Object)$this$asCssRules.getColor()) : TuplesKt.to((Object)$this$asCssRules.getColor(), (Object)$this$asCssRules.getBgColor());
        Color fg = (Color)pair.component1();
        Color bg = (Color)pair.component2();
        Color color = fg;
        if (color != null) {
            it = color;
            boolean bl = false;
            rules.add("color: " + RGB.toHex$default((RGB)it.toSRGB(), (boolean)false, null, (int)3, null));
        }
        Color color2 = bg;
        if (color2 != null) {
            it = color2;
            boolean bl = false;
            rules.add("background-color: " + RGB.toHex$default((RGB)it.toSRGB(), (boolean)false, null, (int)3, null));
        }
        if (Intrinsics.areEqual((Object)$this$asCssRules.getBold(), (Object)true)) {
            rules.add("font-weight: bold");
        }
        if (Intrinsics.areEqual((Object)$this$asCssRules.getItalic(), (Object)true)) {
            rules.add("font-style: italic");
        }
        if (Intrinsics.areEqual((Object)$this$asCssRules.getUnderline(), (Object)true)) {
            rules.add("text-decoration: underline");
        }
        if (Intrinsics.areEqual((Object)$this$asCssRules.getDim(), (Object)true)) {
            rules.add("opacity: 0.5");
        }
        if (Intrinsics.areEqual((Object)$this$asCssRules.getStrikethrough(), (Object)true)) {
            rules.add("text-decoration: line-through");
        }
        return rules;
    }

    private static final String escapeHtml(String $this$escapeHtml) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeHtml, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)">", (String)"&gt;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null), (String)"\\", (String)"&#x27;", (boolean)false, (int)4, null);
    }

    private static final CharSequence addSpansAsHtml$lambda$2(Span it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HtmlRendererKt.escapeHtml(it.getText());
    }
}

