/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.widgets.progress;

import com.github.ajalt.mordant.widgets.progress.ProgressState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ComparableTimeMark;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u0006\u0012\u0002\b\u00030\u0003\u001a\u0016\u0010\u0015\u001a\u00020\u0016*\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0017\u001a\u00020\u0016\u001a?\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\n2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010!\"!\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0004\"!\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004\"!\u0010\u0006\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"!\u0010\u0007\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0004\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0017\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\""}, d2={"isIndeterminate", "", "T", "Lcom/github/ajalt/mordant/widgets/progress/ProgressState;", "(Lcom/github/ajalt/mordant/widgets/progress/ProgressState;)Z", "isPaused", "isRunning", "isFinished", "startTime", "Lkotlin/time/ComparableTimeMark;", "Lcom/github/ajalt/mordant/widgets/progress/ProgressState$Status;", "getStartTime", "(Lcom/github/ajalt/mordant/widgets/progress/ProgressState$Status;)Lkotlin/time/ComparableTimeMark;", "pauseTime", "getPauseTime", "finishTime", "getFinishTime", "calculateTimeRemaining", "Lkotlin/time/Duration;", "elapsedWhenFinished", "calculateTimeElapsed", "frameCount", "", "fps", "ProgressState", "", "total", "", "completed", "animationTime", "status", "speed", "", "(Ljava/lang/Long;JLkotlin/time/ComparableTimeMark;Lcom/github/ajalt/mordant/widgets/progress/ProgressState$Status;Ljava/lang/Double;)Lcom/github/ajalt/mordant/widgets/progress/ProgressState;", "mordant"})
public final class ProgressStateKt {
    public static final <T> boolean isIndeterminate(@NotNull ProgressState<T> $this$isIndeterminate) {
        Intrinsics.checkNotNullParameter($this$isIndeterminate, (String)"<this>");
        return $this$isIndeterminate.getTotal() == null;
    }

    public static final <T> boolean isPaused(@NotNull ProgressState<T> $this$isPaused) {
        Intrinsics.checkNotNullParameter($this$isPaused, (String)"<this>");
        return $this$isPaused.getStatus() instanceof ProgressState.Status.Paused;
    }

    public static final <T> boolean isRunning(@NotNull ProgressState<T> $this$isRunning) {
        Intrinsics.checkNotNullParameter($this$isRunning, (String)"<this>");
        return $this$isRunning.getStatus() instanceof ProgressState.Status.Running;
    }

    public static final <T> boolean isFinished(@NotNull ProgressState<T> $this$isFinished) {
        Intrinsics.checkNotNullParameter($this$isFinished, (String)"<this>");
        return $this$isFinished.getStatus() instanceof ProgressState.Status.Finished;
    }

    @Nullable
    public static final ComparableTimeMark getStartTime(@NotNull ProgressState.Status $this$startTime) {
        ComparableTimeMark comparableTimeMark;
        Intrinsics.checkNotNullParameter((Object)$this$startTime, (String)"<this>");
        ProgressState.Status status = $this$startTime;
        if (status instanceof ProgressState.Status.NotStarted) {
            comparableTimeMark = null;
        } else if (status instanceof ProgressState.Status.Running) {
            comparableTimeMark = ((ProgressState.Status.Running)$this$startTime).getStartTime();
        } else if (status instanceof ProgressState.Status.Paused) {
            comparableTimeMark = ((ProgressState.Status.Paused)$this$startTime).getStartTime();
        } else if (status instanceof ProgressState.Status.Finished) {
            comparableTimeMark = ((ProgressState.Status.Finished)$this$startTime).getStartTime();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return comparableTimeMark;
    }

    @Nullable
    public static final ComparableTimeMark getPauseTime(@NotNull ProgressState.Status $this$pauseTime) {
        Intrinsics.checkNotNullParameter((Object)$this$pauseTime, (String)"<this>");
        return $this$pauseTime instanceof ProgressState.Status.Paused ? ((ProgressState.Status.Paused)$this$pauseTime).getPauseTime() : null;
    }

    @Nullable
    public static final ComparableTimeMark getFinishTime(@NotNull ProgressState.Status $this$finishTime) {
        Intrinsics.checkNotNullParameter((Object)$this$finishTime, (String)"<this>");
        return $this$finishTime instanceof ProgressState.Status.Finished ? ((ProgressState.Status.Finished)$this$finishTime).getFinishTime() : null;
    }

    @Nullable
    public static final Duration calculateTimeRemaining(@NotNull ProgressState<?> $this$calculateTimeRemaining, boolean elapsedWhenFinished) {
        Intrinsics.checkNotNullParameter($this$calculateTimeRemaining, (String)"<this>");
        return $this$calculateTimeRemaining.getStatus() instanceof ProgressState.Status.Finished && elapsedWhenFinished ? Duration.box-impl((long)((ProgressState.Status.Finished)$this$calculateTimeRemaining.getStatus()).getFinishTime().minus-UwyO8pc(((ProgressState.Status.Finished)$this$calculateTimeRemaining.getStatus()).getStartTime())) : ($this$calculateTimeRemaining.getStatus() instanceof ProgressState.Status.Running && $this$calculateTimeRemaining.getSpeed() != null && $this$calculateTimeRemaining.getSpeed() > 0.0 && $this$calculateTimeRemaining.getTotal() != null ? Duration.box-impl((long)DurationKt.toDuration((double)((double)($this$calculateTimeRemaining.getTotal() - $this$calculateTimeRemaining.getCompleted()) / $this$calculateTimeRemaining.getSpeed()), (DurationUnit)DurationUnit.SECONDS)) : null);
    }

    public static /* synthetic */ Duration calculateTimeRemaining$default(ProgressState progressState, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return ProgressStateKt.calculateTimeRemaining(progressState, bl);
    }

    @Nullable
    public static final Duration calculateTimeElapsed(@NotNull ProgressState<?> $this$calculateTimeElapsed) {
        Duration duration;
        Intrinsics.checkNotNullParameter($this$calculateTimeElapsed, (String)"<this>");
        ProgressState.Status status = $this$calculateTimeElapsed.getStatus();
        if (Intrinsics.areEqual((Object)status, (Object)ProgressState.Status.NotStarted.INSTANCE)) {
            duration = null;
        } else if (status instanceof ProgressState.Status.Finished) {
            duration = Duration.box-impl((long)((ProgressState.Status.Finished)$this$calculateTimeElapsed.getStatus()).getFinishTime().minus-UwyO8pc(((ProgressState.Status.Finished)$this$calculateTimeElapsed.getStatus()).getStartTime()));
        } else if (status instanceof ProgressState.Status.Paused) {
            duration = Duration.box-impl((long)((ProgressState.Status.Paused)$this$calculateTimeElapsed.getStatus()).getPauseTime().minus-UwyO8pc(((ProgressState.Status.Paused)$this$calculateTimeElapsed.getStatus()).getStartTime()));
        } else if (status instanceof ProgressState.Status.Running) {
            duration = Duration.box-impl((long)((ProgressState.Status.Running)$this$calculateTimeElapsed.getStatus()).getStartTime().elapsedNow-UwyO8pc());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return duration;
    }

    public static final int frameCount(@NotNull ProgressState<?> $this$frameCount, int fps) {
        Intrinsics.checkNotNullParameter($this$frameCount, (String)"<this>");
        return (int)(Duration.toDouble-impl((long)$this$frameCount.getAnimationTime().elapsedNow-UwyO8pc(), (DurationUnit)DurationUnit.SECONDS) * (double)fps);
    }

    @NotNull
    public static final ProgressState<Unit> ProgressState(@Nullable Long total, long completed2, @NotNull ComparableTimeMark animationTime, @NotNull ProgressState.Status status, @Nullable Double speed2) {
        Intrinsics.checkNotNullParameter((Object)animationTime, (String)"animationTime");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        return new ProgressState<Unit>(Unit.INSTANCE, total, completed2, animationTime, status, speed2, null, 64, null);
    }

    public static /* synthetic */ ProgressState ProgressState$default(Long l, long l2, ComparableTimeMark comparableTimeMark, ProgressState.Status status, Double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            d = null;
        }
        return ProgressStateKt.ProgressState(l, l2, comparableTimeMark, status, d);
    }
}

