/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface;

import com.github.ajalt.mordant.input.InputEvent;
import com.github.ajalt.mordant.input.KeyboardEvent;
import com.github.ajalt.mordant.input.MouseEvent;
import com.github.ajalt.mordant.internal.Utf8Kt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tR\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/PosixEventParser;", "", "readRawByte", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "timeout", "Lkotlin/time/TimeMark;", "(Lkotlin/time/TimeMark;)Ljava/lang/Integer;", "readInputEvent", "Lcom/github/ajalt/mordant/input/InputEvent;", "processMouseEvent", "readUtf8Int", "mordant"})
public final class PosixEventParser {
    @NotNull
    private final Function0<Integer> readRawByte;

    public PosixEventParser(@NotNull Function0<Integer> readRawByte) {
        Intrinsics.checkNotNullParameter(readRawByte, (String)"readRawByte");
        this.readRawByte = readRawByte;
    }

    private final Integer readRawByte(TimeMark timeout) {
        do {
            Integer n;
            if ((n = (Integer)this.readRawByte.invoke()) == null) continue;
            return n;
        } while (timeout.hasNotPassedNow());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final InputEvent readInputEvent(@NotNull TimeMark timeout) {
        String string;
        Ref.CharRef ch;
        String name;
        boolean shift;
        boolean alt;
        boolean ctrl;
        block269: {
            boolean escaped;
            block267: {
                Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
                ctrl = false;
                alt = false;
                shift = false;
                escaped = false;
                name = null;
                StringBuilder s = new StringBuilder();
                ch = new Ref.CharRef();
                Integer n = this.readUtf8Int(timeout);
                if (n == null) {
                    return null;
                }
                String first = Utf8Kt.codepointToString(n);
                if (first.length() > 1) {
                    return new KeyboardEvent(first, false, false, false, 14, null);
                }
                ch.element = first.charAt(0);
                if (ch.element == '\u001b') {
                    escaped = true;
                    Character c = PosixEventParser.readInputEvent$read(timeout, ch, this, s, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MILLISECONDS))));
                    if (c == null) {
                        return new KeyboardEvent("Escape", false, false, false, 14, null);
                    }
                    c.charValue();
                    if (ch.element == '\u001b') {
                        return new KeyboardEvent("Escape", false, false, false, 14, null);
                    }
                }
                if (!escaped || ch.element != 'O' && ch.element != '[') break block267;
                StringBuilder code = new StringBuilder(String.valueOf(ch.element));
                int modifier = 0;
                if (ch.element == 'O') {
                    Character c = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                    if (c == null) {
                        return null;
                    }
                    c.charValue();
                    boolean bl = '0' <= ch.element ? ch.element < ':' : false;
                    if (bl) {
                        modifier = ch.element - '\u0001';
                        Character c2 = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                        if (c2 == null) return null;
                        c2.charValue();
                    }
                    code.append(ch.element);
                } else if (ch.element == '[') {
                    Character c = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                    if (c == null) {
                        return null;
                    }
                    c.charValue();
                    if (ch.element == '[') {
                        code.append(ch.element);
                        Character c3 = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                        if (c3 == null) return null;
                        c3.charValue();
                    } else if (ch.element == 'M') {
                        return this.processMouseEvent(timeout);
                    }
                    int cmdStart = s.length() - 1;
                    int n2 = 3;
                    for (int i = 0; i < n2; ++i) {
                        int it = i;
                        boolean bl = false;
                        boolean bl2 = '0' <= ch.element ? ch.element < ':' : false;
                        if (!bl2) continue;
                        Character c4 = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                        if (c4 == null) return null;
                        c4.charValue();
                    }
                    if (ch.element == ';') {
                        Character c5 = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                        if (c5 == null) {
                            return null;
                        }
                        c5.charValue();
                        boolean bl = '0' <= ch.element ? ch.element < ':' : false;
                        if (bl) {
                            Character c6 = PosixEventParser.readInputEvent$read$default(timeout, ch, this, s, null, 16, null);
                            if (c6 == null) return null;
                            c6.charValue();
                        }
                    }
                    String cmd = s.substring(cmdStart);
                    Regex regex = new Regex("(\\d\\d?)(?:;(\\d))?([~^$])|(\\d{3}~)");
                    Intrinsics.checkNotNull((Object)cmd);
                    MatchResult match = regex.matchEntire((CharSequence)cmd);
                    if (match != null) {
                        if (((CharSequence)match.getGroupValues().get(4)).length() > 0) {
                            code.append((String)match.getGroupValues().get(4));
                        } else {
                            code.append((String)match.getGroupValues().get(1) + (String)match.getGroupValues().get(3));
                            Integer n3 = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(2)));
                            modifier = (n3 != null ? n3 : 1) - 1;
                        }
                    } else {
                        match = new Regex("((\\d;)?(\\d))?([A-Za-z])").matchEntire((CharSequence)cmd);
                        if (match != null) {
                            code.append((String)match.getGroupValues().get(4));
                            Integer n4 = StringsKt.toIntOrNull((String)((String)match.getGroupValues().get(3)));
                            modifier = (n4 != null ? n4 : 1) - 1;
                        } else {
                            code.append(cmd);
                        }
                    }
                }
                ctrl = (modifier & 4) != 0;
                alt = (modifier & 0xA) != 0;
                shift = (modifier & 1) != 0;
                switch (code.toString()) {
                    case "[P": {
                        name = "F1";
                        break;
                    }
                    case "[Q": {
                        name = "F2";
                        break;
                    }
                    case "[R": {
                        name = "F3";
                        break;
                    }
                    case "[S": {
                        name = "F4";
                        break;
                    }
                    case "OP": {
                        name = "F1";
                        break;
                    }
                    case "OQ": {
                        name = "F2";
                        break;
                    }
                    case "OR": {
                        name = "F3";
                        break;
                    }
                    case "OS": {
                        name = "F4";
                        break;
                    }
                    case "[11~": {
                        name = "F1";
                        break;
                    }
                    case "[12~": {
                        name = "F2";
                        break;
                    }
                    case "[13~": {
                        name = "F3";
                        break;
                    }
                    case "[14~": {
                        name = "F4";
                        break;
                    }
                    case "[200~": {
                        name = "PasteStart";
                        break;
                    }
                    case "[201~": {
                        name = "PasteEnd";
                        break;
                    }
                    case "[[A": {
                        name = "F1";
                        break;
                    }
                    case "[[B": {
                        name = "F2";
                        break;
                    }
                    case "[[C": {
                        name = "F3";
                        break;
                    }
                    case "[[D": {
                        name = "F4";
                        break;
                    }
                    case "[[E": {
                        name = "F5";
                        break;
                    }
                    case "[15~": {
                        name = "F5";
                        break;
                    }
                    case "[17~": {
                        name = "F6";
                        break;
                    }
                    case "[18~": {
                        name = "F7";
                        break;
                    }
                    case "[19~": {
                        name = "F8";
                        break;
                    }
                    case "[20~": {
                        name = "F9";
                        break;
                    }
                    case "[21~": {
                        name = "F10";
                        break;
                    }
                    case "[23~": {
                        name = "F11";
                        break;
                    }
                    case "[24~": {
                        name = "F12";
                        break;
                    }
                    case "[A": {
                        name = "ArrowUp";
                        break;
                    }
                    case "[B": {
                        name = "ArrowDown";
                        break;
                    }
                    case "[C": {
                        name = "ArrowRight";
                        break;
                    }
                    case "[D": {
                        name = "ArrowLeft";
                        break;
                    }
                    case "[E": {
                        name = "Clear";
                        break;
                    }
                    case "[F": {
                        name = "End";
                        break;
                    }
                    case "[H": {
                        name = "Home";
                        break;
                    }
                    case "OA": {
                        name = "ArrowUp";
                        break;
                    }
                    case "OB": {
                        name = "ArrowDown";
                        break;
                    }
                    case "OC": {
                        name = "ArrowRight";
                        break;
                    }
                    case "OD": {
                        name = "ArrowLeft";
                        break;
                    }
                    case "OE": {
                        name = "Clear";
                        break;
                    }
                    case "OF": {
                        name = "End";
                        break;
                    }
                    case "OH": {
                        name = "Home";
                        break;
                    }
                    case "[1~": {
                        name = "Home";
                        break;
                    }
                    case "[2~": {
                        name = "Insert";
                        break;
                    }
                    case "[3~": {
                        name = "Delete";
                        break;
                    }
                    case "[4~": {
                        name = "End";
                        break;
                    }
                    case "[5~": {
                        name = "PageUp";
                        break;
                    }
                    case "[6~": {
                        name = "PageDown";
                        break;
                    }
                    case "[[5~": {
                        name = "PageUp";
                        break;
                    }
                    case "[[6~": {
                        name = "PageDown";
                        break;
                    }
                    case "[7~": {
                        name = "Home";
                        break;
                    }
                    case "[8~": {
                        name = "End";
                        break;
                    }
                    case "[a": {
                        name = "ArrowUp";
                        shift = true;
                        break;
                    }
                    case "[b": {
                        name = "ArrowDown";
                        shift = true;
                        break;
                    }
                    case "[c": {
                        name = "ArrowRight";
                        shift = true;
                        break;
                    }
                    case "[d": {
                        name = "ArrowLeft";
                        shift = true;
                        break;
                    }
                    case "[e": {
                        name = "Clear";
                        shift = true;
                        break;
                    }
                    case "[2$": {
                        name = "Insert";
                        shift = true;
                        break;
                    }
                    case "[3$": {
                        name = "Delete";
                        shift = true;
                        break;
                    }
                    case "[5$": {
                        name = "PageUp";
                        shift = true;
                        break;
                    }
                    case "[6$": {
                        name = "PageDown";
                        shift = true;
                        break;
                    }
                    case "[7$": {
                        name = "Home";
                        shift = true;
                        break;
                    }
                    case "[8$": {
                        name = "End";
                        shift = true;
                        break;
                    }
                    case "Oa": {
                        name = "ArrowUp";
                        ctrl = true;
                        break;
                    }
                    case "Ob": {
                        name = "ArrowDown";
                        ctrl = true;
                        break;
                    }
                    case "Oc": {
                        name = "ArrowRight";
                        ctrl = true;
                        break;
                    }
                    case "Od": {
                        name = "ArrowLeft";
                        ctrl = true;
                        break;
                    }
                    case "Oe": {
                        name = "Clear";
                        ctrl = true;
                        break;
                    }
                    case "[2^": {
                        name = "Insert";
                        ctrl = true;
                        break;
                    }
                    case "[3^": {
                        name = "Delete";
                        ctrl = true;
                        break;
                    }
                    case "[5^": {
                        name = "PageUp";
                        ctrl = true;
                        break;
                    }
                    case "[6^": {
                        name = "PageDown";
                        ctrl = true;
                        break;
                    }
                    case "[7^": {
                        name = "Home";
                        ctrl = true;
                        break;
                    }
                    case "[8^": {
                        name = "End";
                        ctrl = true;
                        break;
                    }
                    case "[Z": {
                        name = "Tab";
                        shift = true;
                        break;
                    }
                    default: {
                        name = "Unidentified";
                        break;
                    }
                }
                break block269;
            }
            if (ch.element == '\r') {
                name = "Enter";
                alt = escaped;
            } else if (ch.element == '\n') {
                name = "Enter";
                alt = escaped;
            } else if (ch.element == '\t') {
                name = "Tab";
                alt = escaped;
            } else if (ch.element == '\b' || ch.element == '\u007f') {
                name = "Backspace";
                alt = escaped;
            } else if (ch.element == '\u001b') {
                name = "Escape";
                alt = escaped;
            } else if (ch.element == ' ') {
                name = " ";
                alt = escaped;
            } else if (!escaped && Intrinsics.compare((int)ch.element, (int)26) <= 0) {
                name = String.valueOf((char)(ch.element + 97 - 1));
                ctrl = true;
            } else if (Character.isLetter(ch.element) || Character.isDigit(ch.element)) {
                name = String.valueOf(ch.element);
                shift = 'A' <= ch.element ? ch.element < '[' : false;
                alt = escaped;
            } else if (escaped) {
                name = "Escape";
                alt = true;
            }
        }
        if ((string = name) != null) return new KeyboardEvent(string, ctrl, alt, shift);
        string = String.valueOf(ch.element);
        return new KeyboardEvent(string, ctrl, alt, shift);
    }

    private final InputEvent processMouseEvent(TimeMark timeout) {
        Integer n = this.readUtf8Int(timeout);
        if (n == null) {
            return null;
        }
        int cb = n;
        Integer n2 = this.readUtf8Int(timeout);
        if (n2 == null) {
            return null;
        }
        int cx = n2 - 33;
        Integer it = this.readUtf8Int((TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto(), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MILLISECONDS))));
        boolean bl = false;
        Integer n3 = it;
        int cy = n3 == null ? 0 : n3 - 33;
        boolean shift = (cb & 4) != 0;
        boolean alt = (cb & 8) != 0;
        boolean ctrl = (cb & 0x10) != 0;
        return new MouseEvent(cx, cy, (cb & 3) == 0, (cb & 3) == 1, (cb & 3) == 2, false, false, cb == 64, cb == 65, false, false, ctrl, alt, shift, 1632, null);
    }

    private final Integer readUtf8Int(TimeMark timeout) {
        return Utf8Kt.readBytesAsUtf8((Function0<Integer>)((Function0)() -> PosixEventParser.readUtf8Int$lambda$2(this, timeout)));
    }

    private static final Character readInputEvent$read(TimeMark $timeout, Ref.CharRef ch, PosixEventParser this$0, StringBuilder s, TimeMark t) {
        Integer n = this$0.readRawByte(t);
        if (n == null) {
            return null;
        }
        ch.element = (char)n.intValue();
        s.append(ch.element);
        return Character.valueOf(ch.element);
    }

    static /* synthetic */ Character readInputEvent$read$default(TimeMark timeMark, Ref.CharRef charRef, PosixEventParser posixEventParser, StringBuilder stringBuilder, TimeMark timeMark2, int n, Object object) {
        if ((n & 0x10) != 0) {
            timeMark2 = timeMark;
        }
        return PosixEventParser.readInputEvent$read(timeMark, charRef, posixEventParser, stringBuilder, timeMark2);
    }

    private static final Integer readUtf8Int$lambda$2(PosixEventParser this$0, TimeMark $timeout) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$timeout, (String)"$timeout");
        return this$0.readRawByte($timeout);
    }
}

