/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber.ranges;

import java.util.Iterator;
import korlibs.bignumber.BigInt;
import korlibs.bignumber.internal.ProgressionUtilKt;
import korlibs.bignumber.ranges.BigIntProgressionIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002J\u0011\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002H\u0086\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lkorlibs/bignumber/ranges/BigIntProgression;", "", "Lkorlibs/bignumber/BigInt;", "start", "endInclusive", "step", "(Lkorlibs/bignumber/BigInt;Lkorlibs/bignumber/BigInt;Lkorlibs/bignumber/BigInt;)V", "first", "getFirst", "()Lkorlibs/bignumber/BigInt;", "last", "getLast", "getStep", "equals", "", "other", "", "hashCode", "", "isEmpty", "iterator", "", "toString", "", "Companion", "kbignum"})
public class BigIntProgression
implements Iterable<BigInt>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInt step;
    @NotNull
    private final BigInt first;
    @NotNull
    private final BigInt last;

    public BigIntProgression(@NotNull BigInt start, @NotNull BigInt endInclusive, @NotNull BigInt step) {
        this.step = step;
        if (Intrinsics.areEqual((Object)this.step, (Object)BigInt.Companion.getZERO())) {
            throw new IllegalArgumentException("Step must be non-zero.");
        }
        this.first = start;
        this.last = ProgressionUtilKt.getProgressionLastElement(start, endInclusive, this.step);
    }

    @NotNull
    public final BigInt getStep() {
        return this.step;
    }

    @NotNull
    public final BigInt getFirst() {
        return this.first;
    }

    @NotNull
    public final BigInt getLast() {
        return this.last;
    }

    public boolean isEmpty() {
        return this.step.compareTo(BigInt.Companion.getZERO()) > 0 ? this.first.compareTo(this.last) > 0 : this.first.compareTo(this.last) < 0;
    }

    @Override
    @NotNull
    public Iterator<BigInt> iterator() {
        return new BigIntProgressionIterator(this.first, this.last, this.step);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BigIntProgression && (this.isEmpty() && ((BigIntProgression)other).isEmpty() || Intrinsics.areEqual((Object)this.first, (Object)((BigIntProgression)other).first) && Intrinsics.areEqual((Object)this.last, (Object)((BigIntProgression)other).last) && Intrinsics.areEqual((Object)this.step, (Object)((BigIntProgression)other).step));
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : 31 * (31 * this.first.toInt() + this.last.toInt()) + this.step.toInt();
    }

    @NotNull
    public String toString() {
        return this.step.compareTo(BigInt.Companion.getZERO()) > 0 ? this.first + ".." + this.last + " step " + this.step : this.first + " downTo " + this.last + " step " + this.step.unaryMinus();
    }

    @NotNull
    public final BigIntProgression step(@NotNull BigInt step) {
        return Companion.fromClosedRange(this.first, this.last, this.step.compareTo(BigInt.Companion.getZERO()) > 0 ? step : step.unaryMinus());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lkorlibs/bignumber/ranges/BigIntProgression$Companion;", "", "()V", "fromClosedRange", "Lkorlibs/bignumber/ranges/BigIntProgression;", "rangeStart", "Lkorlibs/bignumber/BigInt;", "rangeEnd", "step", "kbignum"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigIntProgression fromClosedRange(@NotNull BigInt rangeStart, @NotNull BigInt rangeEnd, @NotNull BigInt step) {
            return new BigIntProgression(rangeStart, rangeEnd, step);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

