/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber.internal;

import korlibs.bignumber.BigInt;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u00a8\u0006\n"}, d2={"differenceModulo", "Lkorlibs/bignumber/BigInt;", "a", "b", "c", "getProgressionLastElement", "start", "end", "step", "mod", "kbignum"})
public final class ProgressionUtilKt {
    @NotNull
    public static final BigInt mod(@NotNull BigInt a, @NotNull BigInt b) {
        BigInt mod = a.rem(b);
        return mod.compareTo(BigInt.Companion.getZERO()) >= 0 ? mod : mod.plus(b);
    }

    @NotNull
    public static final BigInt differenceModulo(@NotNull BigInt a, @NotNull BigInt b, @NotNull BigInt c) {
        return ProgressionUtilKt.mod(ProgressionUtilKt.mod(a, c).minus(ProgressionUtilKt.mod(b, c)), c);
    }

    @NotNull
    public static final BigInt getProgressionLastElement(@NotNull BigInt start, @NotNull BigInt end, @NotNull BigInt step) {
        BigInt bigInt;
        if (step.compareTo(BigInt.Companion.getZERO()) > 0) {
            bigInt = start.compareTo(end) >= 0 ? end : end.minus(ProgressionUtilKt.differenceModulo(end, start, step));
        } else if (step.compareTo(BigInt.Companion.getZERO()) < 0) {
            bigInt = start.compareTo(end) <= 0 ? end : end.plus(ProgressionUtilKt.differenceModulo(start, end, step.unaryMinus()));
        } else {
            throw new IllegalArgumentException("Step is zero.");
        }
        return bigInt;
    }
}

