/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.javafx;

import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;
import org.kordamp.ikonli.FontLoader;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.IkonResolverProvider;
import org.kordamp.ikonli.javafx.JavaFXFontLoader;

public class FontIconConverter
extends StyleConverter<String, Ikon> {
    public static StyleConverter<String, Ikon> getInstance() {
        return Holder.INSTANCE;
    }

    private FontIconConverter() {
    }

    public String toString() {
        return "FontIconConverter";
    }

    public Ikon convert(ParsedValue<String, Ikon> value, Font font) {
        String description = ((String)value.getValue()).trim();
        return IkonResolverProvider.getInstance((FontLoader)JavaFXFontLoader.getInstance()).resolve(description).resolve(description);
    }

    private static class Holder {
        static final FontIconConverter INSTANCE = new FontIconConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<String, Ikon[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        public Ikon[] convert(ParsedValue<String, Ikon[]> value, Font font) {
            String[] descriptions = ((String)value.getValue()).split(",");
            Ikon[] ikons = new Ikon[descriptions.length];
            for (int i = 0; i < descriptions.length; ++i) {
                String description = descriptions[i].trim();
                ikons[i] = IkonResolverProvider.getInstance((FontLoader)JavaFXFontLoader.getInstance()).resolve(description).resolve(description);
            }
            return ikons;
        }

        public String toString() {
            return "FontIcon.SequenceConverter";
        }
    }
}

