/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal.terminalinterface.ffm;

import com.github.ajalt.mordant.rendering.Size;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfaceJvmPosix;
import com.github.ajalt.mordant.terminal.terminalinterface.TerminalInterfacePosix;
import com.github.ajalt.mordant.terminal.terminalinterface.ffm.Layouts;
import com.github.ajalt.mordant.terminal.terminalinterface.ffm.LinuxCLibrary;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/ffm/TerminalInterfaceFfmLinux;", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfaceJvmPosix;", "<init>", "()V", "termiosConstants", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "getTermiosConstants", "()Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$TermiosConstants;", "libC", "Lcom/github/ajalt/mordant/terminal/terminalinterface/ffm/LinuxCLibrary;", "isatty", "", "fd", "", "getTerminalSize", "Lcom/github/ajalt/mordant/rendering/Size;", "getStdinTermios", "Lcom/github/ajalt/mordant/terminal/terminalinterface/TerminalInterfacePosix$Termios;", "setStdinTermios", "", "termios", "Companion", "mordant-jvm-ffm"})
public final class TerminalInterfaceFfmLinux
extends TerminalInterfaceJvmPosix {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final LinuxCLibrary libC = new LinuxCLibrary();
    @Deprecated
    public static final int TIOCGWINSZ = 21523;
    @Deprecated
    public static final int TCSADRAIN = 1;

    @NotNull
    public TerminalInterfacePosix.TermiosConstants getTermiosConstants() {
        return TerminalInterfacePosix.Companion.getLinuxTermiosConstants();
    }

    protected boolean isatty(int fd) {
        return this.libC.isatty(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Size getTerminalSize() {
        Size size;
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)arena);
            LinuxCLibrary.winsize size2 = new LinuxCLibrary.winsize(arena);
            size = !this.libC.ioctl(0, 21523, size2.getSegment()) ? null : new Size((int)size2.getWs_col(), (int)size2.getWs_row());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TerminalInterfacePosix.Termios getStdinTermios() {
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)arena);
            LinuxCLibrary.termios termios2 = new LinuxCLibrary.termios(arena);
            if (!this.libC.tcgetattr(0, termios2)) {
                throw new RuntimeException("failed to read terminal settings");
            }
            int n = UInt.constructor-impl((int)termios2.getC_iflag());
            int n2 = UInt.constructor-impl((int)termios2.getC_oflag());
            int n3 = UInt.constructor-impl((int)termios2.getC_cflag());
            int n4 = UInt.constructor-impl((int)termios2.getC_lflag());
            byte[] byArray = termios2.getC_cc().toArray(Layouts.INSTANCE.getBYTE());
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toArray(...)");
            TerminalInterfacePosix.Termios termios3 = new TerminalInterfacePosix.Termios(n, n2, n3, n4, byArray, null);
            return termios3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStdinTermios(@NotNull TerminalInterfacePosix.Termios termios2) {
        Intrinsics.checkNotNullParameter((Object)termios2, (String)"termios");
        AutoCloseable autoCloseable = Arena.ofConfined();
        Throwable throwable = null;
        try {
            Arena arena = (Arena)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)arena);
            LinuxCLibrary.termios nativeTermios = new LinuxCLibrary.termios(arena);
            if (!this.libC.tcgetattr(0, nativeTermios)) {
                throw new RuntimeException("failed to update terminal settings");
            }
            nativeTermios.setC_iflag(termios2.getIflag-pVg5ArA());
            nativeTermios.setC_oflag(termios2.getOflag-pVg5ArA());
            nativeTermios.setC_cflag(termios2.getCflag-pVg5ArA());
            nativeTermios.setC_lflag(termios2.getLflag-pVg5ArA());
            nativeTermios.getC_cc().copyFrom(MemorySegment.ofArray(termios2.getCc()));
            this.libC.tcsetattr(0, 1, nativeTermios);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/ajalt/mordant/terminal/terminalinterface/ffm/TerminalInterfaceFfmLinux$Companion;", "", "<init>", "()V", "TIOCGWINSZ", "", "TCSADRAIN", "mordant-jvm-ffm"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

