/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.utilities.memory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class MemoryInfo {
    private static final boolean PRE_FETCH_DISABLED = Boolean.getBoolean("org.ehcache.shadow.org.terracotta.utilities.disablePreFetchMemoryPoolBeans");
    private static final String BUFFER_POOL_MAPPED = "mapped";
    private static final String BUFFER_POOL_DIRECT = "direct";
    private final MaxDirectMemoryInfo effectiveMaxDirectMemory = MemoryInfo.getMaxDirectMemory();
    private final MaxDirectMemoryInfo configuredMaxDirectMemory = MemoryInfo.getMaxDirectMemoryArg();
    private final List<BufferPoolMXBean> bufferPoolBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    private final Supplier<List<MemoryPoolMXBean>> memoryPoolMXBeanSupplier;
    private static final MemoryInfo INSTANCE = new MemoryInfo();

    public static MemoryInfo getInstance() {
        return INSTANCE;
    }

    private MemoryInfo() {
        if (PRE_FETCH_DISABLED) {
            this.memoryPoolMXBeanSupplier = () -> Collections.unmodifiableList(ManagementFactory.getMemoryPoolMXBeans());
        } else {
            List<MemoryPoolMXBean> memoryPoolMXBeans = Collections.unmodifiableList(ManagementFactory.getMemoryPoolMXBeans());
            this.memoryPoolMXBeanSupplier = () -> memoryPoolMXBeans;
        }
    }

    public long effectiveMaxDirectMemory() {
        return MemoryInfo.maxDirectMemory(this.effectiveMaxDirectMemory);
    }

    public MaxDirectMemoryInfo effectiveMaxDirectMemoryInfo() {
        return this.effectiveMaxDirectMemory;
    }

    public long configuredMaxDirectMemory() {
        return MemoryInfo.maxDirectMemory(this.configuredMaxDirectMemory);
    }

    public MaxDirectMemoryInfo configuredMaxDirectMemoryInfo() {
        return this.configuredMaxDirectMemory;
    }

    public List<MemoryPoolMXBean> memoryPoolMXBeans() {
        return this.memoryPoolMXBeanSupplier.get();
    }

    public long heapInUse() {
        return this.memoryPoolMXBeans().stream().filter(b -> b.getType() == MemoryType.HEAP).filter(MemoryPoolMXBean::isValid).map(MemoryPoolMXBean::getUsage).mapToLong(MemoryUsage::getUsed).sum();
    }

    public long offHeapMemoryInUse() {
        return this.bufferPoolMemory(null);
    }

    public long offHeapBufferCount() {
        return this.bufferPoolCount(null);
    }

    public long directMemoryInUse() {
        return this.bufferPoolMemory(BUFFER_POOL_DIRECT);
    }

    public long directBufferCount() {
        return this.bufferPoolCount(BUFFER_POOL_DIRECT);
    }

    public long mappedMemoryInUse() {
        return this.bufferPoolMemory(BUFFER_POOL_MAPPED);
    }

    public long mappedBufferCount() {
        return this.bufferPoolCount(BUFFER_POOL_MAPPED);
    }

    public static String formatSize(long size) {
        if (size < 0L) {
            return Long.toString(size);
        }
        if (size < 1024L) {
            return size + " B";
        }
        int z = (63 - Long.numberOfLeadingZeros(size)) / 10;
        return String.format("%.1f %siB", (double)size / (double)(1L << z * 10), Character.valueOf(" KMGTPE".charAt(z)));
    }

    private long bufferPoolMemory(String pool) {
        return this.bufferPoolBeans(pool).mapToLong(BufferPoolMXBean::getMemoryUsed).sum();
    }

    private long bufferPoolCount(String pool) {
        return this.bufferPoolBeans(pool).mapToLong(BufferPoolMXBean::getCount).sum();
    }

    private Stream<BufferPoolMXBean> bufferPoolBeans(String pool) {
        Stream<BufferPoolMXBean> bufferPoolMXBeanStream = this.bufferPoolBeans.stream();
        if (pool != null) {
            bufferPoolMXBeanStream = bufferPoolMXBeanStream.filter(bufferPoolMXBean -> bufferPoolMXBean.getName().equals(pool));
        }
        return bufferPoolMXBeanStream;
    }

    private static long maxDirectMemory(MaxDirectMemoryInfo memory) {
        if (memory.maxDirectMemoryAccessFault == null) {
            return memory.maxDirectMemory == null ? -1L : memory.maxDirectMemory;
        }
        return -1L;
    }

    private static MaxDirectMemoryInfo getMaxDirectMemory() {
        ReflectiveOperationException maxDirectMemoryFault = null;
        Long maxDirectMemory = null;
        Class<?> vmClass = null;
        try {
            vmClass = Class.forName("jdk.internal.misc.VM");
        }
        catch (ClassNotFoundException e) {
            try {
                vmClass = Class.forName("sun.misc.VM");
            }
            catch (ClassNotFoundException e1) {
                maxDirectMemoryFault = e;
            }
        }
        if (vmClass != null) {
            try {
                maxDirectMemory = (Long)vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                if (vmClass.getName().startsWith("jdk") && e.getMessage().contains(" does not export ")) {
                    System.err.format("Unable to access %s.maxDirectMemory(): Access to maxDirectMemory() requires the java option '--add-exports %s/%s=ALL-UNNAMED'%n", vmClass.getName(), MemoryInfo.getModuleName(vmClass), vmClass.getPackage().getName());
                }
                maxDirectMemoryFault = e;
            }
            catch (NoSuchMethodException | InvocationTargetException e) {
                maxDirectMemoryFault = e;
            }
        }
        String vmClassName = vmClass == null ? "<unavailable>" : vmClass.getName();
        return new MaxDirectMemoryInfo(maxDirectMemory, vmClassName, maxDirectMemoryFault);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"})
    private static MaxDirectMemoryInfo getMaxDirectMemoryArg() {
        String argId = "-XX:MaxDirectMemorySize=";
        List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        try {
            String maxDirectMemoryArg = null;
            for (String arg : inputArguments) {
                if (!arg.startsWith(argId)) continue;
                maxDirectMemoryArg = arg.substring(argId.length());
            }
            if (maxDirectMemoryArg != null) {
                Matcher matcher = Pattern.compile("([0-9]+)([kKmMgGtT]?)").matcher(maxDirectMemoryArg);
                if (matcher.matches()) {
                    long maxDirectMemory = Long.decode(matcher.group(1));
                    if (!matcher.group(2).isEmpty()) {
                        char scale = matcher.group(2).toLowerCase().charAt(0);
                        switch (scale) {
                            case 't': {
                                maxDirectMemory *= 1024L;
                            }
                            case 'g': {
                                maxDirectMemory *= 1024L;
                            }
                            case 'm': {
                                maxDirectMemory *= 1024L;
                            }
                            case 'k': {
                                maxDirectMemory *= 1024L;
                            }
                        }
                    }
                    return new MaxDirectMemoryInfo(maxDirectMemory, "<-XX:MaxDirectMemorySize>", null);
                }
                return new MaxDirectMemoryInfo(null, "<-XX:MaxDirectMemorySize>", new IllegalStateException("Unexpected MaxDirectMemorySize value: " + maxDirectMemoryArg));
            }
            return new MaxDirectMemoryInfo(null, "<unavailable>", null);
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NumberFormatException e) {
            return new MaxDirectMemoryInfo(null, "<-XX:MaxDirectMemorySize>", e);
        }
    }

    private static String getModuleName(Class<?> clazz) {
        try {
            Object module = Class.class.getDeclaredMethod("getModule", new Class[0]).invoke(clazz, new Object[0]);
            return (String)module.getClass().getDeclaredMethod("getName", new Class[0]).invoke(module, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    public static class MaxDirectMemoryInfo {
        private final Long maxDirectMemory;
        private final String valueSource;
        private final Throwable maxDirectMemoryAccessFault;

        private MaxDirectMemoryInfo(Long maxDirectMemory, String valueSource, Throwable maxDirectMemoryAccessFault) {
            this.maxDirectMemory = maxDirectMemory;
            this.valueSource = valueSource;
            this.maxDirectMemoryAccessFault = maxDirectMemoryAccessFault;
        }

        public Long maxDirectMemory() {
            return this.maxDirectMemory;
        }

        public String valueSource() {
            return this.valueSource;
        }

        public String maxDirectMemoryAccessFault() {
            return this.maxDirectMemoryAccessFault == null ? "" : this.maxDirectMemoryAccessFault.toString();
        }
    }
}

