/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Cache<Key, Value> {
    private final Map<Key, Value> cacheMap;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public Cache() {
        this.cacheMap = new HashMap<Key, Value>();
    }

    public Value get(Key key, Callable<Value> valueDelegate) {
        Value value = this.cacheMap.get(key);
        if (value != null) {
            return value;
        }
        this.lock.writeLock().lock();
        try {
            value = this.cacheMap.get(key);
            if (value == null) {
                value = valueDelegate.call();
                this.cacheMap.put(key, value);
            }
            Value Value = value;
            return Value;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting value from cache", e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

