/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection2;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.LinkedHashMap;
import org.sql2o.Settings;
import org.sql2o.Sql2oException;
import org.sql2o.converters.ConverterException;
import org.sql2o.reflection2.ObjectBuildable;

public class RecordBuilder<T>
implements ObjectBuildable<T> {
    private final Constructor<T> constructor;
    private final LinkedHashMap<String, RecordValue> values = new LinkedHashMap();
    private final Settings settings;

    public RecordBuilder(Class<T> recordClass, Settings settings) {
        this.constructor = recordClass.getDeclaredConstructors()[0];
        this.settings = settings;
        for (RecordComponent recordComponent : recordClass.getRecordComponents()) {
            this.values.put(settings.getNamingConvention().deriveName(recordComponent.getName()), new RecordValue(recordComponent.getType()));
        }
    }

    @Override
    public void withValue(String columnName, Object value) {
        String derivedName = this.settings.getNamingConvention().deriveName(columnName);
        if (!this.values.containsKey(derivedName)) {
            throw new IllegalArgumentException("No such field in record: " + columnName);
        }
        RecordValue convVal = this.values.get(derivedName);
        try {
            convVal.value = this.settings.getQuirks().converterOf(convVal.type).convert(value);
        }
        catch (ConverterException e) {
            throw new Sql2oException("Error trying to convert column " + columnName + " to type " + String.valueOf(convVal.type), e);
        }
    }

    @Override
    public T build() throws ReflectiveOperationException {
        return this.constructor.newInstance(this.values.values().stream().map(recordValue -> recordValue.value).toArray());
    }

    private static class RecordValue {
        public Object value = null;
        public final Class<?> type;

        public RecordValue(Class<?> type) {
            this.type = type;
        }
    }
}

