/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection2;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.sql2o.Settings;
import org.sql2o.Sql2oException;
import org.sql2o.converters.ConverterException;

public class PojoProperty {
    private final String name;
    private final String annotatedName;
    private final Method getter;
    private final Method setter;
    private final Field field;
    private final Settings settings;
    private Class<?> setterType = null;

    public PojoProperty(String name, String annotatedName, Method getter, Method setter, Field field, Settings settings) {
        this.name = name;
        this.annotatedName = annotatedName;
        this.getter = getter;
        this.setter = setter;
        this.field = field;
        if (field != null) {
            this.field.setAccessible(true);
        }
        this.settings = settings;
    }

    public String getName() {
        return this.name;
    }

    public String getAnnotatedName() {
        return this.annotatedName;
    }

    public void SetProperty(Object obj, Object value) throws ReflectiveOperationException {
        if (this.setter != null) {
            try {
                Class<?> propertyType = this.getSetterType();
                Object convertedValue = this.settings.getQuirks().converterOf(propertyType).convert(value);
                if (convertedValue == null && propertyType.isPrimitive()) {
                    return;
                }
                this.setter.invoke(obj, convertedValue);
            }
            catch (ConverterException ex) {
                throw new Sql2oException("Error trying to convert value of type " + value.getClass().getName() + " to property " + this.name + " [" + this.setter.getName() + "] of type " + String.valueOf(this.setter.getDeclaringClass()), ex);
            }
            return;
        }
        if (this.field != null) {
            try {
                Class<?> propertyType = this.field.getType();
                Object convertedValue = this.settings.getQuirks().converterOf(propertyType).convert(value);
                if (convertedValue == null && propertyType.isPrimitive()) {
                    return;
                }
                this.field.set(obj, convertedValue);
            }
            catch (ConverterException ex) {
                throw new Sql2oException("Error trying to convert value of type " + value.getClass().getName() + " to field " + this.name + " of type " + String.valueOf(this.field.getDeclaringClass()), ex);
            }
            return;
        }
        throw new Sql2oException("No setter or field found for property " + this.name);
    }

    public Class<?> getType() {
        if (this.setter != null) {
            return this.setter.getParameters()[0].getType();
        }
        if (this.field != null) {
            return this.field.getType();
        }
        throw new Sql2oException("Unexpected error. Could not get type of property " + this.getName());
    }

    public Object getValue(Object obj) throws ReflectiveOperationException {
        if (this.getter != null) {
            return this.getter.invoke(obj, new Object[0]);
        }
        if (this.field != null) {
            return this.field.get(obj);
        }
        throw new Sql2oException("No getter or field found for property " + this.name);
    }

    public Object initializeWithNewInstance(Object obj) throws ReflectiveOperationException {
        if (this.setter != null) {
            Class<?> propertyType = this.setter.getParameters()[0].getType();
            Object instance = propertyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.setter.invoke(obj, instance);
            return instance;
        }
        if (this.field != null) {
            Class<?> propertyType = this.field.getType();
            Object instance = propertyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.field.set(obj, instance);
            return instance;
        }
        throw new Sql2oException("Could not initialize property " + this.getName() + " no setter or field found.");
    }

    private Class<?> getSetterType() {
        if (this.setterType == null) {
            this.setterType = this.setter.getParameters()[0].getType();
        }
        return this.setterType;
    }
}

