/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.quirks;

import java.util.ServiceLoader;
import org.sql2o.quirks.NoQuirks;
import org.sql2o.quirks.Quirks;
import org.sql2o.quirks.QuirksProvider;

public class QuirksDetector {
    static final ServiceLoader<QuirksProvider> providers = ServiceLoader.load(QuirksProvider.class);

    public static Quirks forURL(String jdbcUrl) {
        for (QuirksProvider quirksProvider : ServiceLoader.load(QuirksProvider.class)) {
            if (!quirksProvider.isUsableForUrl(jdbcUrl)) continue;
            return quirksProvider.provide();
        }
        return new NoQuirks();
    }

    public static Quirks forObject(Object jdbcObject) {
        String jdbcObjectClassName = jdbcObject.getClass().getName().contains("$") ? jdbcObject.getClass().getSuperclass().getCanonicalName() : jdbcObject.getClass().getCanonicalName();
        for (QuirksProvider quirksProvider : ServiceLoader.load(QuirksProvider.class)) {
            if (!quirksProvider.isUsableForClass(jdbcObjectClassName)) continue;
            return quirksProvider.provide();
        }
        return new NoQuirks();
    }
}

