/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters.joda;

import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;

public class JodaDateTimeConverter
implements Converter<DateTime> {
    private final DateTimeZone timeZone;

    public JodaDateTimeConverter(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public JodaDateTimeConverter() {
        this(DateTimeZone.getDefault());
    }

    @Override
    public DateTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        try {
            return new LocalDateTime(val).toDateTime(this.timeZone);
        }
        catch (IllegalArgumentException ex) {
            throw new ConverterException("Error while converting type " + val.getClass().toString() + " to jodatime", ex);
        }
    }

    @Override
    public Object toDatabaseParam(DateTime val) {
        return new Timestamp(val.getMillis());
    }
}

