/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Time;
import java.time.OffsetTime;
import java.util.Date;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class SqlTimeConverter
extends ConverterBase<Time> {
    @Override
    public Time convert(Object val) throws ConverterException {
        if (val instanceof Time) {
            return (Time)val;
        }
        if (val instanceof Date) {
            return new Time(((Date)val).getTime());
        }
        if (val instanceof OffsetTime) {
            return Time.valueOf(((OffsetTime)val).toLocalTime());
        }
        if (val instanceof Number) {
            return new Time(((Number)val).longValue());
        }
        if (val instanceof String) {
            return Time.valueOf((String)val);
        }
        throw new ConverterException("Cannot convert type " + String.valueOf(val.getClass()) + " to java.sql.Time");
    }
}

