/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class OffsetDateTimeConverter
extends ConverterBase<OffsetDateTime> {
    @Override
    public OffsetDateTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetDateTime) {
            return (OffsetDateTime)val;
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toInstant().atZone(ZoneOffset.systemDefault()).toOffsetDateTime();
        }
        if (val instanceof Long) {
            Instant instant = Instant.ofEpochMilli((Long)val);
            return instant.atZone(ZoneOffset.systemDefault()).toOffsetDateTime();
        }
        if (val instanceof String) {
            try {
                return OffsetDateTime.parse((String)val);
            }
            catch (Exception e) {
                throw new ConverterException("Cannot convert String with value '" + String.valueOf(val) + "' to java.time.OffsetDateTime", e);
            }
        }
        throw new ConverterException("Cannot convert type " + String.valueOf(val.getClass()) + " to java.time.OffsetDateTime");
    }
}

