/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class LocalDateConverter
extends ConverterBase<LocalDate> {
    @Override
    public LocalDate convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return ((Date)val).toLocalDate();
        }
        if (val instanceof Long) {
            return Instant.ofEpochMilli((Long)val).atOffset(ZoneOffset.UTC).toLocalDate();
        }
        if (val instanceof String) {
            try {
                return LocalDate.parse((String)val);
            }
            catch (Exception e) {
                throw new ConverterException("Cannot convert string with value '" + String.valueOf(val) + " to java.time.LocalDate", e);
            }
        }
        throw new ConverterException("Cannot convert type " + val.getClass().toString() + " to java.time.LocalDate");
    }
}

