/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sql2o.Query;
import org.sql2o.Sql2oException;

class ArrayParameters {
    ArrayParameters() {
    }

    static String updateQueryAndParametersIndexes(String parsedQuery, Map<String, List<Integer>> parameterNamesToIndexes, Map<String, Query.ParameterSetter> parameters, boolean allowArrayParameters) {
        List<ArrayParameter> arrayParametersSortedAsc = ArrayParameters.arrayParametersSortedAsc(parameterNamesToIndexes, parameters, allowArrayParameters);
        if (arrayParametersSortedAsc.isEmpty()) {
            return parsedQuery;
        }
        ArrayParameters.updateParameterNamesToIndexes(parameterNamesToIndexes, arrayParametersSortedAsc);
        return ArrayParameters.updateQueryWithArrayParameters(parsedQuery, arrayParametersSortedAsc);
    }

    static Map<String, List<Integer>> updateParameterNamesToIndexes(Map<String, List<Integer>> parametersNameToIndex, List<ArrayParameter> arrayParametersSortedAsc) {
        for (Map.Entry<String, List<Integer>> parameterNameToIndexes : parametersNameToIndex.entrySet()) {
            ArrayList<Integer> newParameterIndex = new ArrayList<Integer>(parameterNameToIndexes.getValue().size());
            for (Integer parameterIndex : parameterNameToIndexes.getValue()) {
                newParameterIndex.add(ArrayParameters.computeNewIndex(parameterIndex, arrayParametersSortedAsc));
            }
            parameterNameToIndexes.setValue(newParameterIndex);
        }
        return parametersNameToIndex;
    }

    static int computeNewIndex(int index, List<ArrayParameter> arrayParametersSortedAsc) {
        int newIndex = index;
        for (ArrayParameter arrayParameter : arrayParametersSortedAsc) {
            if (index > arrayParameter.parameterIndex) {
                newIndex = newIndex + arrayParameter.parameterCount - 1;
                continue;
            }
            return newIndex;
        }
        return newIndex;
    }

    private static List<ArrayParameter> arrayParametersSortedAsc(Map<String, List<Integer>> parameterNamesToIndexes, Map<String, Query.ParameterSetter> parameters, boolean allowArrayParameters) {
        ArrayList<ArrayParameter> arrayParameters = new ArrayList<ArrayParameter>();
        for (Map.Entry<String, Query.ParameterSetter> parameter : parameters.entrySet()) {
            if (parameter.getValue().parameterCount <= 1) continue;
            if (!allowArrayParameters) {
                throw new Sql2oException("Array parameters are not allowed in batch mode");
            }
            for (int i : parameterNamesToIndexes.get(parameter.getKey())) {
                arrayParameters.add(new ArrayParameter(i, parameter.getValue().parameterCount));
            }
        }
        Collections.sort(arrayParameters);
        return arrayParameters;
    }

    static String updateQueryWithArrayParameters(String parsedQuery, List<ArrayParameter> arrayParametersSortedAsc) {
        if (arrayParametersSortedAsc.isEmpty()) {
            return parsedQuery;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<ArrayParameter> parameterToReplaceIt = arrayParametersSortedAsc.iterator();
        ArrayParameter nextParameterToReplace = parameterToReplaceIt.next();
        int currentIndex = 1;
        for (char c : parsedQuery.toCharArray()) {
            if (nextParameterToReplace != null && c == '?') {
                if (currentIndex == nextParameterToReplace.parameterIndex) {
                    sb.append("?");
                    for (int i = 1; i < nextParameterToReplace.parameterCount; ++i) {
                        sb.append(",?");
                    }
                    nextParameterToReplace = parameterToReplaceIt.hasNext() ? parameterToReplaceIt.next() : null;
                } else {
                    sb.append(c);
                }
                ++currentIndex;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static class ArrayParameter
    implements Comparable<ArrayParameter> {
        int parameterIndex;
        int parameterCount;

        ArrayParameter(int parameterIndex, int parameterCount) {
            this.parameterIndex = parameterIndex;
            this.parameterCount = parameterCount;
        }

        @Override
        public int compareTo(ArrayParameter o) {
            return Integer.compare(this.parameterIndex, o.parameterIndex);
        }
    }
}

