/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.tws;

import com.xorrus.trading.ib.tws.api.response.CommissionReportMessageResponse;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.GenericValueDB;
import com.xorrus.trading.lot.business.entity.query.QAccountExecutionDB;
import com.xorrus.trading.lot.business.event.Event;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionUpdatedEvent;
import com.xorrus.trading.lot.ib.entity.AccountExecutionDBKt;
import io.ebean.DB;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/lot/ib/tws/UpdateAccountExecutionTwsCommissionReportCmd;", "", "event", "Lcom/xorrus/trading/ib/tws/api/response/CommissionReportMessageResponse;", "<init>", "(Lcom/xorrus/trading/ib/tws/api/response/CommissionReportMessageResponse;)V", "getEvent", "()Lcom/xorrus/trading/ib/tws/api/response/CommissionReportMessageResponse;", "execute", "", "Companion", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nUpdateAccountExecutionTwsCommissionReportCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateAccountExecutionTwsCommissionReportCmd.kt\ncom/xorrus/trading/lot/ib/tws/UpdateAccountExecutionTwsCommissionReportCmd\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,41:1\n37#2,2:42\n*S KotlinDebug\n*F\n+ 1 UpdateAccountExecutionTwsCommissionReportCmd.kt\ncom/xorrus/trading/lot/ib/tws/UpdateAccountExecutionTwsCommissionReportCmd\n*L\n32#1:42,2\n*E\n"})
public final class UpdateAccountExecutionTwsCommissionReportCmd {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommissionReportMessageResponse event;
    @NotNull
    private static final Logger logger;

    public UpdateAccountExecutionTwsCommissionReportCmd(@NotNull CommissionReportMessageResponse event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.event = event;
    }

    @NotNull
    public final CommissionReportMessageResponse getEvent() {
        return this.event;
    }

    public final void execute() {
        EventManagerKt.collectEvents(arg_0 -> UpdateAccountExecutionTwsCommissionReportCmd.execute$lambda$0(this, arg_0));
    }

    private static final Unit execute$lambda$0(UpdateAccountExecutionTwsCommissionReportCmd this$0, EventCollector $this$collectEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        AccountExecutionDB accountExecution = (AccountExecutionDB)AccountExecutionDBKt.eqIbTwsExecId(new QAccountExecutionDB(), this$0.event.getExecId()).findOne();
        if (accountExecution == null) {
            logger.warn("AccountExecution " + this$0.event.getExecId() + " not found in DB, skipping commission update");
            return Unit.INSTANCE;
        }
        String[] stringArray = new String[]{"commission", "commissionCurrency"};
        $this$collectEvents.event((Event)new AccountExecutionUpdatedEvent(accountExecution, stringArray));
        accountExecution.setCommission(this$0.event.getCommission().toMinScale());
        accountExecution.setCommissionCurrency(this$0.event.getCurrency());
        stringArray = new SpreadBuilder(3);
        stringArray.add((Object)accountExecution);
        stringArray.add((Object)accountExecution.getGenericContainer());
        Object object = accountExecution.getGenericContainer();
        if (object == null || (object = object.getValues()) == null) {
            object = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new GenericValueDB[0]));
        DB.saveAll((Collection)CollectionsKt.listOfNotNull((Object[])stringArray.toArray(new Object[stringArray.size()])));
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(UpdateAccountExecutionTwsCommissionReportCmd.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        UpdateAccountExecutionTwsCommissionReportCmd.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/trading/lot/ib/tws/UpdateAccountExecutionTwsCommissionReportCmd$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "laboftrades-ib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

