/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.tws;

import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.ib.tws.api.response.ContractDetailsResponse;
import com.xorrus.trading.ib.tws.api.type.Execution;
import com.xorrus.trading.ib.tws.api.type.Side;
import com.xorrus.trading.lot.business.entity.AccountDB;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.GenericValueDB;
import com.xorrus.trading.lot.business.entity.UserDB;
import com.xorrus.trading.lot.business.entity.query.QAccountDB;
import com.xorrus.trading.lot.business.entity.query.QAccountExecutionDB;
import com.xorrus.trading.lot.business.event.Event;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionUpdatedEvent;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionsUpdatedEvent;
import com.xorrus.trading.lot.business.event.impl.AccountsUpdatedEvent;
import com.xorrus.trading.lot.ib.entity.AccountDBKt;
import com.xorrus.trading.lot.ib.entity.AccountExecutionDBKt;
import io.ebean.DB;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/lot/ib/tws/ImportAccountExecutionFromHistoricalTwsExecutionCmd;", "", "user", "Lcom/xorrus/trading/lot/business/entity/UserDB;", "contracts", "", "Lcom/xorrus/trading/ib/tws/api/response/ContractDetailsResponse;", "event", "Lcom/xorrus/trading/ib/tws/api/type/Execution;", "<init>", "(Lcom/xorrus/trading/lot/business/entity/UserDB;Ljava/util/List;Lcom/xorrus/trading/ib/tws/api/type/Execution;)V", "getUser", "()Lcom/xorrus/trading/lot/business/entity/UserDB;", "getContracts", "()Ljava/util/List;", "getEvent", "()Lcom/xorrus/trading/ib/tws/api/type/Execution;", "execute", "", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nImportAccountExecutionFromHistoricalTwsExecutionCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportAccountExecutionFromHistoricalTwsExecutionCmd.kt\ncom/xorrus/trading/lot/ib/tws/ImportAccountExecutionFromHistoricalTwsExecutionCmd\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n1#2:84\n37#3,2:85\n37#3,2:87\n*S KotlinDebug\n*F\n+ 1 ImportAccountExecutionFromHistoricalTwsExecutionCmd.kt\ncom/xorrus/trading/lot/ib/tws/ImportAccountExecutionFromHistoricalTwsExecutionCmd\n*L\n77#1:85,2\n78#1:87,2\n*E\n"})
public final class ImportAccountExecutionFromHistoricalTwsExecutionCmd {
    @NotNull
    private final UserDB user;
    @NotNull
    private final List<ContractDetailsResponse> contracts;
    @NotNull
    private final Execution event;

    public ImportAccountExecutionFromHistoricalTwsExecutionCmd(@NotNull UserDB user, @NotNull List<ContractDetailsResponse> contracts, @NotNull Execution event) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(contracts, (String)"contracts");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.user = user;
        this.contracts = contracts;
        this.event = event;
    }

    @NotNull
    public final UserDB getUser() {
        return this.user;
    }

    @NotNull
    public final List<ContractDetailsResponse> getContracts() {
        return this.contracts;
    }

    @NotNull
    public final Execution getEvent() {
        return this.event;
    }

    public final int execute() {
        return ((Number)EventManagerKt.collectEvents(arg_0 -> ImportAccountExecutionFromHistoricalTwsExecutionCmd.execute$lambda$0(this, arg_0))).intValue();
    }

    private static final int execute$lambda$0(ImportAccountExecutionFromHistoricalTwsExecutionCmd this$0, EventCollector $this$collectEvents) {
        String[] stringArray;
        AccountExecutionDB accountExecution;
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        if (!(this$0.contracts.size() == 1)) {
            boolean $i$a$-require-ImportAccountExecutionFromHistoricalTwsExecutionCmd$execute$1$22 = false;
            String $i$a$-require-ImportAccountExecutionFromHistoricalTwsExecutionCmd$execute$1$22 = "Expected 1 contract, got " + this$0.contracts.size();
            throw new IllegalArgumentException($i$a$-require-ImportAccountExecutionFromHistoricalTwsExecutionCmd$execute$1$22.toString());
        }
        ContractDetailsResponse contract = (ContractDetailsResponse)CollectionsKt.first(this$0.contracts);
        AccountDB account = (AccountDB)AccountDBKt.eqIbAccountId(new QAccountDB(), this$0.event.getAccount()).findOne();
        if (account == null) {
            AccountDB accountDB;
            AccountDB it = accountDB = new AccountDB();
            boolean bl = false;
            it.setCaption(this$0.event.getAccount());
            AccountDBKt.setIbAccountId(it, this$0.event.getAccount());
            it.setUser(this$0.user);
            it.setBroker("ib");
            account = accountDB;
            $this$collectEvents.event((Event)AccountsUpdatedEvent.INSTANCE);
        }
        if ((accountExecution = (AccountExecutionDB)AccountExecutionDBKt.eqIbTwsExecId(new QAccountExecutionDB(), this$0.event.getExecId()).findOne()) == null) {
            accountExecution = (AccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)AccountExecutionDBKt.eqConId(new QAccountExecutionDB(), this$0.event.getConId()).getSize().eq((Object)this$0.event.getShares())).getPrice().eq((Object)this$0.event.getPrice().toMinScale())).getAccount().eq((Object)account)).findOne();
        }
        if (accountExecution == null) {
            accountExecution = new AccountExecutionDB();
            accountExecution.setAccount(account);
            ((Collection)account.getExecutions()).add(accountExecution);
            $this$collectEvents.event((Event)AccountExecutionsUpdatedEvent.INSTANCE);
        } else {
            stringArray = new String[]{"ibTwsExec", "price", "currency", "size", "executionTimestamp", "multiplier", "ibExecId"};
            $this$collectEvents.event((Event)new AccountExecutionUpdatedEvent(accountExecution, stringArray));
        }
        accountExecution.setPrice(this$0.event.getPrice().toMinScale());
        accountExecution.setCurrency(this$0.event.getCurrency());
        accountExecution.setSize(this$0.event.getShares().times(this$0.event.getSide() == Side.BUY ? XbignumKt.toXBigNum$default((int)1, (int)0, (int)1, null) : XbignumKt.toXBigNum$default((int)-1, (int)0, (int)1, null)));
        accountExecution.setExecutionTimestamp(this$0.event.getTime());
        XBigNum xBigNum = this$0.event.getMultiplier();
        if (xBigNum == null) {
            xBigNum = XBigNum.Companion.getONE();
        }
        accountExecution.setMultiplier(xBigNum);
        AccountExecutionDBKt.setIbConId(accountExecution, contract.getConId());
        AccountExecutionDBKt.setIbTwsExecId(accountExecution, this$0.event.getExecId());
        stringArray = new SpreadBuilder(6);
        stringArray.add((Object)account);
        stringArray.add((Object)accountExecution);
        stringArray.add((Object)account.getGenericContainer());
        stringArray.add((Object)accountExecution.getGenericContainer());
        Object object = account.getGenericContainer();
        if (object == null || (object = object.getValues()) == null) {
            object = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = (Collection)object;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new GenericValueDB[0]));
        Object object2 = accountExecution.getGenericContainer();
        if (object2 == null || (object2 = object2.getValues()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        $this$toTypedArray$iv = (Collection)object2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new GenericValueDB[0]));
        return DB.saveAll((Collection)CollectionsKt.listOfNotNull((Object[])stringArray.toArray(new Object[stringArray.size()])));
    }
}

