/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.flex.tradeconfirmation.importer;

import com.xorrus.trading.lot.business.entity.UserDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.TradeConfirmationXmlParser;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.importer.FlexTradeConfirmationImport;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.FlexQueryResponse;
import com.xorrus.tradng.lot.common.task.AbstractTask;
import com.xorrus.tradng.lot.common.task.TaskMode;
import io.ebean.DB;
import io.ebean.Transaction;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/IBFlexTradeConfirmationImporterTask;", "Lcom/xorrus/tradng/lot/common/task/AbstractTask;", "file", "Ljava/nio/file/Path;", "user", "Lcom/xorrus/trading/lot/business/entity/UserDB;", "parentJob", "Lkotlinx/coroutines/Job;", "<init>", "(Ljava/nio/file/Path;Lcom/xorrus/trading/lot/business/entity/UserDB;Lkotlinx/coroutines/Job;)V", "getFile", "()Ljava/nio/file/Path;", "getUser", "()Lcom/xorrus/trading/lot/business/entity/UserDB;", "execute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "mode", "Lcom/xorrus/tradng/lot/common/task/TaskMode;", "getMode", "()Lcom/xorrus/tradng/lot/common/task/TaskMode;", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nIBFlexTradeConfirmationImporterTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IBFlexTradeConfirmationImporterTask.kt\ncom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/IBFlexTradeConfirmationImporterTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class IBFlexTradeConfirmationImporterTask
extends AbstractTask {
    @NotNull
    private final Path file;
    @NotNull
    private final UserDB user;

    public IBFlexTradeConfirmationImporterTask(@NotNull Path file, @NotNull UserDB user, @NotNull Job parentJob) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)parentJob, (String)"parentJob");
        super("IB Flex Trade-Confirmation importieren", parentJob, null, 4, null);
        this.file = file;
        this.user = user;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @NotNull
    public final UserDB getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Unit> $completion) {
        Object it;
        this.setInfo("Parse Flex Query...");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(this.file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        AutoCloseable autoCloseable = inputStream;
        Throwable throwable = null;
        try {
            it = (InputStream)autoCloseable;
            boolean bl = false;
            it = TradeConfirmationXmlParser.INSTANCE.parse((InputStream)it, true);
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Object response = it;
        this.setInfo("Importiere FlexQuery...");
        autoCloseable = (AutoCloseable)DB.beginTransaction();
        throwable = null;
        try {
            Transaction tx = (Transaction)autoCloseable;
            boolean bl = false;
            EventManagerKt.collectEvents(arg_0 -> IBFlexTradeConfirmationImporterTask.execute$lambda$1$0(this, (FlexQueryResponse)response, arg_0));
            tx.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.setInfo("Flex erfolgreich importiert.");
        return Unit.INSTANCE;
    }

    @NotNull
    public TaskMode getMode() {
        return TaskMode.BACKGROUND_QUEUED;
    }

    private static final Unit execute$lambda$1$0(IBFlexTradeConfirmationImporterTask this$0, FlexQueryResponse $response, EventCollector $this$collectEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        new FlexTradeConfirmationImport(this$0.user, $response).execute($this$collectEvents);
        return Unit.INSTANCE;
    }
}

