/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.flex.tradeconfirmation.importer;

import com.xorrus.trading.lot.business.entity.AccountDB;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.GenericValueDB;
import com.xorrus.trading.lot.business.entity.query.QAccountDB;
import com.xorrus.trading.lot.business.entity.query.QAccountExecutionDB;
import com.xorrus.trading.lot.business.event.Event;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionUpdatedEvent;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionsUpdatedEvent;
import com.xorrus.trading.lot.ib.entity.AccountDBKt;
import com.xorrus.trading.lot.ib.entity.AccountExecutionDBKt;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.TradeConfirm;
import io.ebean.DB;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/FlexTradeImport;", "", "tradeConfirm", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/TradeConfirm;", "symbols", "", "", "", "<init>", "(Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/TradeConfirm;Ljava/util/Map;)V", "getTradeConfirm", "()Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/TradeConfirm;", "getSymbols", "()Ljava/util/Map;", "execute", "Lcom/xorrus/trading/lot/business/entity/AccountExecutionDB;", "collector", "Lcom/xorrus/trading/lot/business/event/EventCollector;", "Companion", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nFlexTradeImport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlexTradeImport.kt\ncom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/FlexTradeImport\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n37#2,2:132\n*S KotlinDebug\n*F\n+ 1 FlexTradeImport.kt\ncom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/FlexTradeImport\n*L\n120#1:132,2\n*E\n"})
public final class FlexTradeImport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TradeConfirm tradeConfirm;
    @NotNull
    private final Map<Integer, String> symbols;
    @NotNull
    private static final Logger logger;

    public FlexTradeImport(@NotNull TradeConfirm tradeConfirm, @NotNull Map<Integer, String> symbols) {
        Intrinsics.checkNotNullParameter((Object)tradeConfirm, (String)"tradeConfirm");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        this.tradeConfirm = tradeConfirm;
        this.symbols = symbols;
    }

    @NotNull
    public final TradeConfirm getTradeConfirm() {
        return this.tradeConfirm;
    }

    @NotNull
    public final Map<Integer, String> getSymbols() {
        return this.symbols;
    }

    @Nullable
    public final AccountExecutionDB execute(@NotNull EventCollector collector) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        EventCollector $this$execute_u24lambda_u240 = collector;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)this.tradeConfirm.getAssetCategory(), (Object)"CASH")) {
            logger.debug("Ignoring cash trade: {}", (Object)this.tradeConfirm);
            return null;
        }
        Object object = AccountDBKt.eqIbAccountId(new QAccountDB(), this.tradeConfirm.getAccountId()).findOne();
        Intrinsics.checkNotNull((Object)object);
        AccountDB account = (AccountDB)object;
        AccountExecutionDB accountExecution = null;
        if (Intrinsics.areEqual((Object)this.tradeConfirm.getTransactionType(), (Object)"ExchTrade")) {
            accountExecution = (AccountExecutionDB)AccountExecutionDBKt.eqIbFlexExecId(AccountExecutionDBKt.eqIbTransactionType(new QAccountExecutionDB(), "TRANSACTION_TYPE_EXCHANGE_TRADE"), this.tradeConfirm.getExecId()).findOne();
            AccountExecutionDB accountExecutionDB = accountExecution;
            if (accountExecutionDB == null) {
                List list = ((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)AccountExecutionDBKt.eqConId(AccountExecutionDBKt.isNullIbFlexExecId(AccountExecutionDBKt.isNullIbTransactionType(new QAccountExecutionDB())), this.tradeConfirm.getConid()).getSize().eq((Object)this.tradeConfirm.getQuantity())).getPrice().eq((Object)this.tradeConfirm.getPrice().toMinScale())).getAccount().eq((Object)account)).orderBy()).getExecutionTimestamp().desc()).findList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findList(...)");
                accountExecutionDB = (AccountExecutionDB)CollectionsKt.firstOrNull((List)list);
            }
            accountExecution = accountExecutionDB;
        } else if (Intrinsics.areEqual((Object)this.tradeConfirm.getTransactionType(), (Object)"BookTrade")) {
            accountExecution = (AccountExecutionDB)AccountExecutionDBKt.eqIbFlexExecId(AccountExecutionDBKt.eqIbTransactionType(new QAccountExecutionDB(), "TRANSACTION_TYPE_BOOK_TRADE"), this.tradeConfirm.getDateTime().toString()).findOne();
            AccountExecutionDB accountExecutionDB = accountExecution;
            if (accountExecutionDB == null) {
                List list = ((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)((QAccountExecutionDB)AccountExecutionDBKt.eqConId(AccountExecutionDBKt.isNullIbFlexExecId(AccountExecutionDBKt.isNullIbTransactionType(new QAccountExecutionDB())), this.tradeConfirm.getConid()).getSize().eq((Object)this.tradeConfirm.getQuantity())).getPrice().eq((Object)this.tradeConfirm.getPrice().toMinScale())).getAccount().eq((Object)account)).orderBy()).getExecutionTimestamp().desc()).findList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findList(...)");
                accountExecutionDB = (AccountExecutionDB)CollectionsKt.firstOrNull((List)list);
            }
            accountExecution = accountExecutionDB;
        } else {
            throw new IllegalStateException(("Unknown transaction type: " + this.tradeConfirm.getTransactionType() + " for trade: " + this.tradeConfirm).toString());
        }
        if (accountExecution == null) {
            accountExecution = new AccountExecutionDB();
            accountExecution.setAccount(account);
            ((Collection)account.getExecutions()).add(accountExecution);
            if (Intrinsics.areEqual((Object)this.tradeConfirm.getTransactionType(), (Object)"ExchTrade")) {
                AccountExecutionDBKt.setIbTransactionType(accountExecution, "TRANSACTION_TYPE_EXCHANGE_TRADE");
                AccountExecutionDBKt.setIbFlexExecId(accountExecution, this.tradeConfirm.getExecId());
            } else {
                AccountExecutionDBKt.setIbTransactionType(accountExecution, "TRANSACTION_TYPE_BOOK_TRADE");
                AccountExecutionDBKt.setIbFlexExecId(accountExecution, this.tradeConfirm.getDateTime().toString());
            }
            $this$execute_u24lambda_u240.event((Event)AccountExecutionsUpdatedEvent.INSTANCE);
        } else {
            stringArray = new String[]{"symbol", "ibExecId", "ibConId", "size", "price", "commission", "multiplier", "currency", "executionTimestamp"};
            $this$execute_u24lambda_u240.event((Event)new AccountExecutionUpdatedEvent(accountExecution, stringArray));
        }
        AccountExecutionDBKt.setIbConId(accountExecution, this.tradeConfirm.getConid());
        String string = this.symbols.get(this.tradeConfirm.getConid());
        if (string == null) {
            throw new IllegalStateException(("Kein Symbol f\u00fcr conid = " + this.tradeConfirm.getConid() + " " + this.tradeConfirm.getSymbol() + " gefunden").toString());
        }
        accountExecution.setSymbol(string);
        accountExecution.setSize(this.tradeConfirm.getQuantity());
        accountExecution.setPrice(this.tradeConfirm.getPrice().toMinScale());
        accountExecution.setCommission(this.tradeConfirm.getCommission());
        accountExecution.setMultiplier(this.tradeConfirm.getMultiplier());
        accountExecution.setCurrency(this.tradeConfirm.getCurrency());
        accountExecution.setExecutionTimestamp(this.tradeConfirm.getDateTime());
        stringArray = new SpreadBuilder(3);
        stringArray.add((Object)accountExecution);
        stringArray.add((Object)accountExecution.getGenericContainer());
        Object object2 = accountExecution.getGenericContainer();
        if (object2 == null || (object2 = object2.getValues()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = (Collection)object2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new GenericValueDB[0]));
        DB.saveAll((Collection)CollectionsKt.listOfNotNull((Object[])stringArray.toArray(new Object[stringArray.size()])));
        return accountExecution;
    }

    static {
        Logger logger = LoggerFactory.getLogger(FlexTradeImport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FlexTradeImport.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/importer/FlexTradeImport$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "laboftrades-ib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

