/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.flex.activity.importer;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.lot.business.entity.AccountDB;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.GenericValueDB;
import com.xorrus.trading.lot.business.entity.query.QAccountDB;
import com.xorrus.trading.lot.business.entity.query.QAccountExecutionDB;
import com.xorrus.trading.lot.business.event.Event;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionUpdatedEvent;
import com.xorrus.trading.lot.business.event.impl.AccountExecutionsUpdatedEvent;
import com.xorrus.trading.lot.ib.entity.AccountDBKt;
import com.xorrus.trading.lot.ib.entity.AccountExecutionDBKt;
import com.xorrus.trading.lot.ib.flex.activity.xml.OptionEAE;
import com.xorrus.trading.lot.ib.flex.activity.xml.Trade;
import io.ebean.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/xorrus/trading/lot/ib/flex/activity/importer/FlexTradeImport;", "", "trade", "Lcom/xorrus/trading/lot/ib/flex/activity/xml/Trade;", "symbols", "", "", "", "oeaes", "", "Lcom/xorrus/trading/lot/ib/flex/activity/xml/OptionEAE;", "executionOrders", "", "Lkotlinx/datetime/LocalDate;", "", "<init>", "(Lcom/xorrus/trading/lot/ib/flex/activity/xml/Trade;Ljava/util/Map;Ljava/util/List;Ljava/util/Map;)V", "getTrade", "()Lcom/xorrus/trading/lot/ib/flex/activity/xml/Trade;", "getSymbols", "()Ljava/util/Map;", "getOeaes", "()Ljava/util/List;", "getExecutionOrders", "execute", "Lcom/xorrus/trading/lot/business/entity/AccountExecutionDB;", "collector", "Lcom/xorrus/trading/lot/business/event/EventCollector;", "Companion", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nFlexTradeImport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlexTradeImport.kt\ncom/xorrus/trading/lot/ib/flex/activity/importer/FlexTradeImport\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,125:1\n382#2,7:126\n774#3:133\n865#3,2:134\n1869#3,2:136\n37#4,2:138\n*S KotlinDebug\n*F\n+ 1 FlexTradeImport.kt\ncom/xorrus/trading/lot/ib/flex/activity/importer/FlexTradeImport\n*L\n92#1:126,7\n107#1:133\n107#1:134,2\n107#1:136,2\n116#1:138,2\n*E\n"})
public final class FlexTradeImport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Trade trade;
    @NotNull
    private final Map<Integer, String> symbols;
    @NotNull
    private final List<OptionEAE> oeaes;
    @NotNull
    private final Map<LocalDate, Long> executionOrders;
    @NotNull
    private static final Logger logger;

    public FlexTradeImport(@NotNull Trade trade, @NotNull Map<Integer, String> symbols, @NotNull List<OptionEAE> oeaes, @NotNull Map<LocalDate, Long> executionOrders) {
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter(oeaes, (String)"oeaes");
        Intrinsics.checkNotNullParameter(executionOrders, (String)"executionOrders");
        this.trade = trade;
        this.symbols = symbols;
        this.oeaes = oeaes;
        this.executionOrders = executionOrders;
    }

    @NotNull
    public final Trade getTrade() {
        return this.trade;
    }

    @NotNull
    public final Map<Integer, String> getSymbols() {
        return this.symbols;
    }

    @NotNull
    public final List<OptionEAE> getOeaes() {
        return this.oeaes;
    }

    @NotNull
    public final Map<LocalDate, Long> getExecutionOrders() {
        return this.executionOrders;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AccountExecutionDB execute(@NotNull EventCollector collector) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Object object;
        Object $this$getOrPut$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        EventCollector $this$execute_u24lambda_u240 = collector;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)this.trade.getAssetCategory(), (Object)"CASH")) {
            logger.debug("Ignoring cash trade: {}", (Object)this.trade);
            return null;
        }
        Object object2 = AccountDBKt.eqIbAccountId(new QAccountDB(), this.trade.getAccountId()).findOne();
        Intrinsics.checkNotNull((Object)object2);
        AccountDB account = (AccountDB)object2;
        AccountExecutionDB accountExecution = null;
        if (Intrinsics.areEqual((Object)this.trade.getTransactionType(), (Object)"ExchTrade")) {
            accountExecution = AccountExecutionDBKt.findIbTransactionTypeAndFlexExecId(QAccountExecutionDB.Companion, "TRANSACTION_TYPE_EXCHANGE_TRADE", this.trade.getIbExecID());
        } else if (Intrinsics.areEqual((Object)this.trade.getTransactionType(), (Object)"BookTrade")) {
            accountExecution = AccountExecutionDBKt.findIbTransactionTypeAndFlexExecId(QAccountExecutionDB.Companion, "TRANSACTION_TYPE_BOOK_TRADE", this.trade.getConid() + " " + this.trade.getDateTime());
        } else {
            throw new IllegalStateException(("Unknown transaction type: " + this.trade.getTransactionType() + " for trade: " + this.trade).toString());
        }
        if (accountExecution == null) {
            accountExecution = new AccountExecutionDB();
            accountExecution.setAccount(account);
            ((Collection)account.getExecutions()).add(accountExecution);
            if (Intrinsics.areEqual((Object)this.trade.getTransactionType(), (Object)"ExchTrade")) {
                AccountExecutionDBKt.setIbTransactionType(accountExecution, "TRANSACTION_TYPE_EXCHANGE_TRADE");
                AccountExecutionDBKt.setIbFlexExecId(accountExecution, this.trade.getIbExecID());
            } else {
                AccountExecutionDBKt.setIbTransactionType(accountExecution, "TRANSACTION_TYPE_BOOK_TRADE");
                AccountExecutionDBKt.setIbFlexExecId(accountExecution, this.trade.getConid() + " " + this.trade.getDateTime());
            }
            $this$execute_u24lambda_u240.event((Event)AccountExecutionsUpdatedEvent.INSTANCE);
        } else {
            stringArray = new String[]{"ibFlexExecId", "ibConId", "size", "price", "commission", "multiplier", "currency", "executionTimestamp", "symbol"};
            $this$execute_u24lambda_u240.event((Event)new AccountExecutionUpdatedEvent(accountExecution, stringArray));
        }
        stringArray = this.executionOrders;
        LocalDate localDate = DateKt.toLocalDate$default((Instant)this.trade.getDateTime(), null, (int)1, null);
        Map<LocalDate, Long> map = this.executionOrders;
        LocalDate key$iv = DateKt.toLocalDate$default((Instant)this.trade.getDateTime(), null, (int)1, null);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl2 = false;
            Long answer$iv = 0L;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        $this$getOrPut$iv = ((Number)object).longValue() + 1L;
        long it = ((Number)$this$getOrPut$iv).longValue();
        boolean $i$a$-also-FlexTradeImport$execute$1$32 = false;
        accountExecution.setExecutionOrder(Long.valueOf(it));
        stringArray.put(localDate, $this$getOrPut$iv);
        AccountExecutionDBKt.setIbConId(accountExecution, this.trade.getConid());
        String string = this.symbols.get(this.trade.getConid());
        Intrinsics.checkNotNull((Object)string);
        accountExecution.setSymbol(string);
        accountExecution.setSize(this.trade.getQuantity());
        accountExecution.setMultiplier(this.trade.getMultiplier());
        accountExecution.setPrice(this.trade.getTradePrice().toMinScale());
        accountExecution.setCommission(this.trade.getIbCommission());
        accountExecution.setExecutionTimestamp(this.trade.getDateTime());
        accountExecution.setReportDate(this.trade.getReportDate());
        accountExecution.setCurrency(this.trade.getCurrency());
        Iterable $this$filter$iv = this.oeaes;
        boolean $i$f$filter = false;
        $this$getOrPut$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator $i$a$-also-FlexTradeImport$execute$1$32 = $this$filterTo$iv$iv.iterator();
        while ($i$a$-also-FlexTradeImport$execute$1$32.hasNext()) {
            Object element$iv$iv = $i$a$-also-FlexTradeImport$execute$1$32.next();
            OptionEAE it2 = (OptionEAE)element$iv$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it2.getTradeID(), (Object)this.trade.getTradeID())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OptionEAE oae = (OptionEAE)element$iv;
            boolean bl4 = false;
            if (Intrinsics.areEqual((Object)oae.getRealizedPnl(), (Object)XBigNum.Companion.getZERO())) continue;
            String string2 = oae.getTransactionType();
            if (Intrinsics.areEqual((Object)string2, (Object)"Assignment")) {
                accountExecution.setSettlement(XbignumKt.toXBigNum$default((int)-1, (int)0, (int)1, null).times(oae.getMtmPnl()));
                continue;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"Exercise")) continue;
            accountExecution.setSettlement(XbignumKt.toXBigNum$default((int)-1, (int)0, (int)1, null).times(oae.getMtmPnl()));
        }
        stringArray = new SpreadBuilder(3);
        stringArray.add((Object)accountExecution);
        stringArray.add((Object)accountExecution.getGenericContainer());
        Object object3 = accountExecution.getGenericContainer();
        if (object3 == null || (object3 = object3.getValues()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = (Collection)object3;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new GenericValueDB[0]));
        DB.saveAll((Collection)CollectionsKt.listOfNotNull((Object[])stringArray.toArray(new Object[stringArray.size()])));
        return accountExecution;
    }

    static {
        Logger logger = LoggerFactory.getLogger(FlexTradeImport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FlexTradeImport.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/trading/lot/ib/flex/activity/importer/FlexTradeImport$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "laboftrades-ib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

