/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import com.xorrus.trading.lot.business.entity.LogEntryDB;
import com.xorrus.trading.lot.business.entity.UserDB;
import com.xorrus.trading.lot.business.event.EventManager;
import com.xorrus.trading.lot.business.event.impl.LogEntryCreatedEvent;
import io.ebean.DB;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/xorrus/trading/lot/logging/EbeanAppender;", "Lch/qos/logback/core/AppenderBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "appenders", "", "Lch/qos/logback/core/Appender;", "userProvider", "Lkotlin/Function0;", "Lcom/xorrus/trading/lot/business/entity/UserDB;", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "getAppenders", "()Ljava/util/List;", "getUserProvider", "()Lkotlin/jvm/functions/Function0;", "start", "", "stop", "append", "event", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nEbeanAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EbeanAppender.kt\ncom/xorrus/trading/lot/logging/EbeanAppender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n1869#2,2:44\n1869#2,2:46\n*S KotlinDebug\n*F\n+ 1 EbeanAppender.kt\ncom/xorrus/trading/lot/logging/EbeanAppender\n*L\n19#1:42,2\n23#1:44,2\n38#1:46,2\n*E\n"})
public final class EbeanAppender
extends AppenderBase<ILoggingEvent> {
    @NotNull
    private final List<Appender<ILoggingEvent>> appenders;
    @NotNull
    private final Function0<UserDB> userProvider;

    public EbeanAppender(@NotNull List<? extends Appender<ILoggingEvent>> appenders, @NotNull Function0<UserDB> userProvider) {
        Intrinsics.checkNotNullParameter(appenders, (String)"appenders");
        Intrinsics.checkNotNullParameter(userProvider, (String)"userProvider");
        this.appenders = appenders;
        this.userProvider = userProvider;
    }

    @NotNull
    public final List<Appender<ILoggingEvent>> getAppenders() {
        return this.appenders;
    }

    @NotNull
    public final Function0<UserDB> getUserProvider() {
        return this.userProvider;
    }

    public void start() {
        super.start();
        Iterable $this$forEach$iv = this.appenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Appender it = (Appender)element$iv;
            boolean bl = false;
            it.start();
        }
    }

    public void stop() {
        Iterable $this$forEach$iv = this.appenders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Appender it = (Appender)element$iv;
            boolean bl = false;
            it.stop();
        }
        super.stop();
    }

    protected void append(@NotNull ILoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            LogEntryDB entry = new LogEntryDB();
            String string = event.getLevel().levelStr;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"levelStr");
            entry.setLevel(string);
            String string2 = event.getFormattedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFormattedMessage(...)");
            entry.setMessage(string2);
            Instant instant = event.getInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"getInstant(...)");
            entry.setTimestamp(InstantConversionsJDK8Kt.toKotlinInstant((Instant)instant));
            entry.setUser((UserDB)this.userProvider.invoke());
            DB.save((Object)entry);
            EventManager.INSTANCE.fireEvent(new LogEntryCreatedEvent(entry));
        }
        catch (Exception exception) {
            Iterable $this$forEach$iv = this.appenders;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Appender it = (Appender)element$iv;
                boolean bl = false;
                it.doAppend((Object)event);
            }
        }
    }
}

