/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.db.migration;

import com.xorrus.common.dbmigration.command.Command;
import com.xorrus.common.dbmigration.dialect.MetaModelDialect;
import com.xorrus.common.dbmigration.dialect.SqlDatabaseDialect;
import com.xorrus.common.dbmigration.meta.Database;
import com.xorrus.trading.lot.business.db.migration.AbstractDatabaseUpgrade;
import com.xorrus.trading.lot.business.db.migration.Db_versionKt;
import com.xorrus.trading.lot.business.db.migration.Upgrade001;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/xorrus/trading/lot/business/db/migration/DatabaseUpgradeManager;", "", "<init>", "()V", "DATABASE_VERSION", "", "updateDatabase", "", "dataSource", "Ljavax/sql/DataSource;", "collectAvailableUpgrades", "", "Lcom/xorrus/trading/lot/business/db/migration/AbstractDatabaseUpgrade;", "buildUpgradeClassName", "", "upgradeNumber", "logger", "Lorg/slf4j/Logger;", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nDatabaseUpgradeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseUpgradeManager.kt\ncom/xorrus/trading/lot/business/db/migration/DatabaseUpgradeManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,111:1\n536#2:112\n521#2,6:113\n536#2:119\n521#2,6:120\n1285#3,2:126\n1299#3,4:128\n1869#3,2:133\n1869#3,2:137\n216#4:132\n217#4:135\n216#4:136\n217#4:139\n*S KotlinDebug\n*F\n+ 1 DatabaseUpgradeManager.kt\ncom/xorrus/trading/lot/business/db/migration/DatabaseUpgradeManager\n*L\n33#1:112\n33#1:113,6\n36#1:119\n36#1:120,6\n41#1:126,2\n41#1:128,4\n56#1:133,2\n66#1:137,2\n52#1:132\n52#1:135\n62#1:136\n62#1:139\n*E\n"})
public final class DatabaseUpgradeManager {
    @NotNull
    public static final DatabaseUpgradeManager INSTANCE = new DatabaseUpgradeManager();
    private static final int DATABASE_VERSION = 47;
    @NotNull
    private static final Logger logger;

    private DatabaseUpgradeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void updateDatabase(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Closeable closeable = (Closeable)new Sql2o(dataSource).open();
        Throwable throwable = null;
        try {
            void $this$associateWithTo$iv$iv;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Map<Integer, AbstractDatabaseUpgrade> availableUpgrades;
            Connection con = (Connection)closeable;
            boolean bl = false;
            con.getJdbcConnection().setAutoCommit(false);
            Intrinsics.checkNotNull((Object)con);
            int currentVersion = Db_versionKt.fetchCurrentDatabaseVersion(con);
            con.commit(false);
            if (!(currentVersion <= 47)) {
                boolean $i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232 = false;
                String $i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232 = "Aktuelle Datenbank (version = " + currentVersion + ") ist neuer als die Anwendung (APPLICATION_DB_VERSION = 47).";
                throw new IllegalArgumentException($i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232.toString());
            }
            logger.info("Aktuelle Datenbankversion = " + currentVersion);
            logger.info("Ziel-Datenbankversion = 47");
            Map<Integer, AbstractDatabaseUpgrade> $this$filter$iv = availableUpgrades = INSTANCE.collectAvailableUpgrades();
            boolean $i$f$filter = false;
            Map<Integer, AbstractDatabaseUpgrade> map = $this$filter$iv;
            Map<Integer, AbstractDatabaseUpgrade> destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                int upgradeVersion = ((Number)entry2.getKey()).intValue();
                if (!(upgradeVersion > currentVersion)) continue;
                destination$iv$iv.put((Integer)entry.getKey(), (AbstractDatabaseUpgrade)entry.getValue());
            }
            Map<Integer, AbstractDatabaseUpgrade> missingUpgrades = destination$iv$iv;
            Map<Integer, AbstractDatabaseUpgrade> $this$filter$iv2 = availableUpgrades;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Map<Integer, AbstractDatabaseUpgrade> destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo232 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv3;
                Map.Entry entry = element$iv$iv3 = iterator2.next();
                boolean bl3 = false;
                int upgradeVersion = ((Number)entry.getKey()).intValue();
                if (!(upgradeVersion <= currentVersion)) continue;
                destination$iv$iv2.put((Integer)element$iv$iv3.getKey(), (AbstractDatabaseUpgrade)element$iv$iv3.getValue());
            }
            Map<Integer, AbstractDatabaseUpgrade> executedUpgrades = destination$iv$iv2;
            Iterable $this$associateWith$iv = availableUpgrades.values();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $i$f$filterTo232 = $this$associateWith$iv;
            Map map2 = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv4 : $this$associateWithTo$iv$iv) {
                void upgrade;
                AbstractDatabaseUpgrade upgradeVersion = (AbstractDatabaseUpgrade)element$iv$iv4;
                Object t = element$iv$iv4;
                Map map3 = map2;
                boolean bl4 = false;
                upgrade.buildCommands();
                List<Command> list = upgrade.getCommands();
                map3.put(t, list);
            }
            Map mapUpgradeToCommands = map2;
            SqlDatabaseDialect databaseDialect = Db_versionKt.findDatabaseDialect(dataSource);
            Database database = new Database(databaseDialect);
            MetaModelDialect metaModelDialect = new MetaModelDialect(databaseDialect);
            Map<Integer, AbstractDatabaseUpgrade> $this$forEach$iv = executedUpgrades;
            boolean bl3 = false;
            Iterator<Map.Entry<Object, Object>> iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry;
                Map.Entry entry3 = entry = iterator3.next();
                boolean bl5 = false;
                AbstractDatabaseUpgrade upgrade = (AbstractDatabaseUpgrade)entry3.getValue();
                logger.debug("Executing " + Reflection.getOrCreateKotlinClass(upgrade.getClass()).getSimpleName());
                List commands = (List)MapsKt.getValue((Map)mapUpgradeToCommands, (Object)upgrade);
                Iterable $this$forEach$iv2 = commands;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Command command = (Command)element$iv2;
                    boolean bl6 = false;
                    metaModelDialect.execute(con, database, command);
                }
            }
            $this$forEach$iv = missingUpgrades;
            boolean bl4 = false;
            iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<Object, Object> entry;
                Map.Entry<Object, Object> entry4 = entry = iterator3.next();
                boolean bl7 = false;
                int version = ((Number)entry4.getKey()).intValue();
                AbstractDatabaseUpgrade upgrade = (AbstractDatabaseUpgrade)entry4.getValue();
                List commands = (List)MapsKt.getValue((Map)mapUpgradeToCommands, (Object)upgrade);
                logger.info("Executing " + Reflection.getOrCreateKotlinClass(upgrade.getClass()).getSimpleName());
                Iterable $this$forEach$iv3 = commands;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Command command = (Command)element$iv3;
                    boolean bl8 = false;
                    databaseDialect.execute(con, database, command);
                    metaModelDialect.execute(con, database, command);
                }
                Db_versionKt.updateDbVersionTable(con, version);
                con.commit(false);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Map<Integer, AbstractDatabaseUpgrade> collectAvailableUpgrades() {
        AbstractDatabaseUpgrade upgrade;
        Map upgrades = new LinkedHashMap();
        int upgradeNumber = 1;
        do {
            String upgradeClassName = this.buildUpgradeClassName(upgradeNumber);
            Class<?> clazz = Class.forName(upgradeClassName);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            KClass clazz2 = JvmClassMappingKt.getKotlinClass(clazz);
            Object object = KClasses.createInstance((KClass)clazz2);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.xorrus.trading.lot.business.db.migration.AbstractDatabaseUpgrade");
            upgrade = (AbstractDatabaseUpgrade)object;
            upgrades.put(upgradeNumber, upgrade);
        } while ((upgradeNumber += upgrade.getStep()) <= 47);
        return upgrades;
    }

    private final String buildUpgradeClassName(int upgradeNumber) {
        String string = Reflection.getOrCreateKotlinClass(Upgrade001.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        String baseClassName = StringsKt.substringBefore$default((String)string, (String)"001", null, (int)2, null);
        String versionPart = StringsKt.padStart((String)String.valueOf(upgradeNumber), (int)3, (char)'0');
        return baseClassName + versionPart;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DatabaseUpgradeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DatabaseUpgradeManager.logger = logger;
    }
}

