/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.cmd.trade;

import com.xorrus.trading.lot.business.entity.ExecutionDB;
import com.xorrus.trading.lot.business.entity.PartDB;
import com.xorrus.trading.lot.business.entity.StepDB;
import com.xorrus.trading.lot.business.entity.TradeDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.business.event.impl.ExecutionDeletedEvent;
import com.xorrus.trading.lot.business.event.impl.PartDeletedEvent;
import com.xorrus.trading.lot.business.event.impl.StepDeletedEvent;
import com.xorrus.trading.lot.business.event.impl.TradeDeletedEvent;
import io.ebean.DB;
import io.ebean.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/xorrus/trading/lot/business/cmd/trade/DeleteTradesCmd;", "", "trades", "", "Lcom/xorrus/trading/lot/business/entity/TradeDB;", "<init>", "(Ljava/util/List;)V", "", "([Lcom/xorrus/trading/lot/business/entity/TradeDB;)V", "getTrades", "()Ljava/util/List;", "execute", "", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nDeleteTradesCmd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteTradesCmd.kt\ncom/xorrus/trading/lot/business/cmd/trade/DeleteTradesCmd\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,38:1\n1374#2:39\n1460#2,5:40\n1374#2:45\n1460#2,5:46\n1374#2:51\n1460#2,5:52\n1869#2,2:57\n1869#2,2:59\n1869#2,2:61\n1869#2,2:63\n37#3,2:65\n37#3,2:67\n37#3,2:69\n37#3,2:71\n*S KotlinDebug\n*F\n+ 1 DeleteTradesCmd.kt\ncom/xorrus/trading/lot/business/cmd/trade/DeleteTradesCmd\n*L\n17#1:39\n17#1:40,5\n18#1:45\n18#1:46,5\n19#1:51\n19#1:52,5\n21#1:57,2\n22#1:59,2\n23#1:61,2\n24#1:63,2\n28#1:65,2\n29#1:67,2\n30#1:69,2\n31#1:71,2\n*E\n"})
public final class DeleteTradesCmd {
    @NotNull
    private final List<TradeDB> trades;

    public DeleteTradesCmd(@NotNull List<TradeDB> trades) {
        Intrinsics.checkNotNullParameter(trades, (String)"trades");
        this.trades = trades;
    }

    @NotNull
    public final List<TradeDB> getTrades() {
        return this.trades;
    }

    public DeleteTradesCmd(TradeDB ... trades) {
        Intrinsics.checkNotNullParameter((Object)trades, (String)"trades");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(trades, trades.length)));
    }

    public final void execute() {
        EventManagerKt.collectEvents(arg_0 -> DeleteTradesCmd.execute$lambda$0(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit execute$lambda$0(DeleteTradesCmd this$0, EventCollector $this$collectEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        AutoCloseable autoCloseable = (AutoCloseable)DB.beginTransaction();
        Throwable throwable = null;
        try {
            Iterator $this$flatMapTo$iv$iv;
            Object element$iv$iv3;
            void $this$flatMapTo$iv$iv2;
            void $this$flatMapTo$iv$iv3;
            Transaction tx = (Transaction)autoCloseable;
            boolean bl = false;
            Iterable $this$flatMap$iv = this$0.trades;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv3) {
                TradeDB it = (TradeDB)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getSteps();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List steps = (List)destination$iv$iv;
            Iterable $this$flatMap$iv2 = this$0.trades;
            boolean $i$f$flatMap2 = false;
            destination$iv$iv = $this$flatMap$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv3 : $this$flatMapTo$iv$iv2) {
                TradeDB it = (TradeDB)element$iv$iv3;
                boolean bl3 = false;
                Iterable list$iv$iv = it.getParts();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List parts = (List)destination$iv$iv2;
            Iterable $this$flatMap$iv3 = this$0.trades;
            boolean $i$f$flatMap3 = false;
            destination$iv$iv2 = $this$flatMap$iv3;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo3 = false;
            element$iv$iv3 = $this$flatMapTo$iv$iv.iterator();
            while (element$iv$iv3.hasNext()) {
                Object element$iv$iv4 = element$iv$iv3.next();
                TradeDB it = (TradeDB)element$iv$iv4;
                boolean bl4 = false;
                Iterable list$iv$iv = it.getExecutions();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List executions = (List)destination$iv$iv3;
            Iterable $this$forEach$iv = this$0.trades;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TradeDB trade = (TradeDB)element$iv;
                boolean bl5 = false;
                $this$collectEvents.event(new TradeDeletedEvent(trade, trade.getStrategy()));
            }
            $this$forEach$iv = steps;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StepDB step = (StepDB)element$iv;
                boolean bl6 = false;
                $this$collectEvents.event(new StepDeletedEvent(step));
            }
            $this$forEach$iv = parts;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PartDB part = (PartDB)element$iv;
                boolean bl7 = false;
                $this$collectEvents.event(new PartDeletedEvent(part));
            }
            $this$forEach$iv = executions;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExecutionDB execution = (ExecutionDB)element$iv;
                boolean bl8 = false;
                $this$collectEvents.event(new ExecutionDeletedEvent(execution));
            }
            SpreadBuilder spreadBuilder = new SpreadBuilder(4);
            Collection $this$toTypedArray$iv = executions;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new ExecutionDB[0]));
            $this$toTypedArray$iv = steps;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new StepDB[0]));
            $this$toTypedArray$iv = parts;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new PartDB[0]));
            $this$toTypedArray$iv = this$0.trades;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new TradeDB[0]));
            DB.deleteAll((Collection)CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()])));
            tx.commit();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }
}

