/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.cmd.trade;

import com.xorrus.trading.lot.business.entity.StrategyDB;
import com.xorrus.trading.lot.business.entity.TradeDB;
import com.xorrus.trading.lot.business.entity.UserDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.business.event.impl.TradeCreatedEvent;
import io.ebean.DB;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/lot/business/cmd/trade/CreateTradeCmd;", "", "user", "Lcom/xorrus/trading/lot/business/entity/UserDB;", "strategy", "Lcom/xorrus/trading/lot/business/entity/StrategyDB;", "<init>", "(Lcom/xorrus/trading/lot/business/entity/UserDB;Lcom/xorrus/trading/lot/business/entity/StrategyDB;)V", "getUser", "()Lcom/xorrus/trading/lot/business/entity/UserDB;", "getStrategy", "()Lcom/xorrus/trading/lot/business/entity/StrategyDB;", "trade", "Lcom/xorrus/trading/lot/business/entity/TradeDB;", "getTrade", "()Lcom/xorrus/trading/lot/business/entity/TradeDB;", "setTrade", "(Lcom/xorrus/trading/lot/business/entity/TradeDB;)V", "execute", "laboftrades-business-alt"})
public final class CreateTradeCmd {
    @NotNull
    private final UserDB user;
    @NotNull
    private final StrategyDB strategy;
    public TradeDB trade;

    public CreateTradeCmd(@NotNull UserDB user, @NotNull StrategyDB strategy) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.user = user;
        this.strategy = strategy;
    }

    @NotNull
    public final UserDB getUser() {
        return this.user;
    }

    @NotNull
    public final StrategyDB getStrategy() {
        return this.strategy;
    }

    @NotNull
    public final TradeDB getTrade() {
        TradeDB tradeDB = this.trade;
        if (tradeDB != null) {
            return tradeDB;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"trade");
        return null;
    }

    public final void setTrade(@NotNull TradeDB tradeDB) {
        Intrinsics.checkNotNullParameter((Object)tradeDB, (String)"<set-?>");
        this.trade = tradeDB;
    }

    @NotNull
    public final CreateTradeCmd execute() {
        return (CreateTradeCmd)EventManagerKt.collectEvents(arg_0 -> CreateTradeCmd.execute$lambda$0(this, arg_0));
    }

    private static final CreateTradeCmd execute$lambda$0(CreateTradeCmd this$0, EventCollector $this$collectEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        this$0.setTrade(new TradeDB());
        this$0.getTrade().setUser(this$0.user);
        this$0.getTrade().setStrategy(this$0.strategy);
        DB.save((Object)this$0.getTrade());
        $this$collectEvents.event(new TradeCreatedEvent(this$0.getTrade()));
        return this$0;
    }
}

