/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.cmd.execution;

import com.xorrus.trading.lot.business.entity.ExecutionDB;
import com.xorrus.trading.lot.business.entity.StepDB;
import com.xorrus.trading.lot.business.entity.TradeDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import io.ebean.DB;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/xorrus/trading/lot/business/cmd/execution/AssignExecutionsToTrade;", "", "executions", "", "Lcom/xorrus/trading/lot/business/entity/ExecutionDB;", "trade", "Lcom/xorrus/trading/lot/business/entity/TradeDB;", "<init>", "(Ljava/util/List;Lcom/xorrus/trading/lot/business/entity/TradeDB;)V", "getExecutions", "()Ljava/util/List;", "getTrade", "()Lcom/xorrus/trading/lot/business/entity/TradeDB;", "execute", "", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nAssignExecutionsToTrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssignExecutionsToTrade.kt\ncom/xorrus/trading/lot/business/cmd/execution/AssignExecutionsToTrade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1869#2,2:29\n*S KotlinDebug\n*F\n+ 1 AssignExecutionsToTrade.kt\ncom/xorrus/trading/lot/business/cmd/execution/AssignExecutionsToTrade\n*L\n12#1:29,2\n*E\n"})
public final class AssignExecutionsToTrade {
    @NotNull
    private final List<ExecutionDB> executions;
    @NotNull
    private final TradeDB trade;

    public AssignExecutionsToTrade(@NotNull List<ExecutionDB> executions, @NotNull TradeDB trade) {
        Intrinsics.checkNotNullParameter(executions, (String)"executions");
        Intrinsics.checkNotNullParameter((Object)trade, (String)"trade");
        this.executions = executions;
        this.trade = trade;
    }

    @NotNull
    public final List<ExecutionDB> getExecutions() {
        return this.executions;
    }

    @NotNull
    public final TradeDB getTrade() {
        return this.trade;
    }

    public final int execute() {
        return ((Number)EventManagerKt.collectEvents(arg_0 -> AssignExecutionsToTrade.execute$lambda$0(this, arg_0))).intValue();
    }

    private static final int execute$lambda$0(AssignExecutionsToTrade this$0, EventCollector $this$collectEvents) {
        Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
        Iterable $this$forEach$iv = this$0.executions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutionDB execution = (ExecutionDB)element$iv;
            boolean bl = false;
            TradeDB oldTrade = execution.getTrade();
            if (execution.getStep() != null) {
                StepDB stepDB = execution.getStep();
                if (!Intrinsics.areEqual((Object)(stepDB != null ? stepDB.getTrade() : null), (Object)this$0.trade)) {
                    StepDB oldStep = execution.getStep();
                    execution.setStep(null);
                }
            }
            execution.setTrade(this$0.trade);
        }
        return DB.saveAll((Collection)this$0.executions);
    }
}

