/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.cmd.accountexecution;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.ExecutionDB;
import com.xorrus.trading.lot.business.entity.StrategyDB;
import com.xorrus.trading.lot.business.entity.TradeDB;
import com.xorrus.trading.lot.business.entity.UserDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import io.ebean.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStrategy;", "", "user", "Lcom/xorrus/trading/lot/business/entity/UserDB;", "accountExecutions", "", "Lcom/xorrus/trading/lot/business/entity/AccountExecutionDB;", "strategy", "Lcom/xorrus/trading/lot/business/entity/StrategyDB;", "<init>", "(Lcom/xorrus/trading/lot/business/entity/UserDB;Ljava/util/List;Lcom/xorrus/trading/lot/business/entity/StrategyDB;)V", "getUser", "()Lcom/xorrus/trading/lot/business/entity/UserDB;", "getAccountExecutions", "()Ljava/util/List;", "getStrategy", "()Lcom/xorrus/trading/lot/business/entity/StrategyDB;", "execute", "", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nAssignAccountExecutionsToStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssignAccountExecutionsToStrategy.kt\ncom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,44:1\n1740#2,3:45\n1563#2:49\n1634#2,3:50\n1#3:48\n37#4,2:53\n*S KotlinDebug\n*F\n+ 1 AssignAccountExecutionsToStrategy.kt\ncom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStrategy\n*L\n10#1:45,3\n19#1:49\n19#1:50,3\n40#1:53,2\n*E\n"})
public final class AssignAccountExecutionsToStrategy {
    @NotNull
    private final UserDB user;
    @NotNull
    private final List<AccountExecutionDB> accountExecutions;
    @NotNull
    private final StrategyDB strategy;

    public AssignAccountExecutionsToStrategy(@NotNull UserDB user, @NotNull List<AccountExecutionDB> accountExecutions, @NotNull StrategyDB strategy) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(accountExecutions, (String)"accountExecutions");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.user = user;
        this.accountExecutions = accountExecutions;
        this.strategy = strategy;
    }

    @NotNull
    public final UserDB getUser() {
        return this.user;
    }

    @NotNull
    public final List<AccountExecutionDB> getAccountExecutions() {
        return this.accountExecutions;
    }

    @NotNull
    public final StrategyDB getStrategy() {
        return this.strategy;
    }

    public final int execute() {
        return ((Number)EventManagerKt.collectEvents(arg_0 -> AssignAccountExecutionsToStrategy.execute$lambda$0(this, arg_0))).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final int execute$lambda$0(AssignAccountExecutionsToStrategy this$0, EventCollector $this$collectEvents) {
        void $this$mapTo$iv$iv;
        boolean $this$all$iv2;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
            Iterable $this$all$iv2 = this$0.accountExecutions;
            boolean $i$f$all = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv2) {
                    AccountExecutionDB it = (AccountExecutionDB)element$iv;
                    boolean bl = false;
                    if (it.getExecutions().isEmpty()) continue;
                    v0 = false;
                    break block8;
                }
                v0 = $this$all$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$all$iv2) {
            String $i$f$all = "Assertion failed";
            throw new AssertionError((Object)$i$f$all);
        }
        TradeDB trade = new TradeDB();
        trade.setUser(this$0.user);
        trade.setStrategy(this$0.strategy);
        Iterable $i$f$all = this$0.accountExecutions;
        Object object = trade;
        SpreadBuilder spreadBuilder = $i$f$all.iterator();
        if (!spreadBuilder.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it = (AccountExecutionDB)spreadBuilder.next();
        boolean bl = false;
        it = (Comparable)((AccountExecutionDB)it).getExecutionTimestamp();
        while (spreadBuilder.hasNext()) {
            Object it2 = (AccountExecutionDB)spreadBuilder.next();
            $i$a$-minOf-AssignAccountExecutionsToStrategy$execute$1$2 = false;
            if (it.compareTo(it2 = (Comparable)((AccountExecutionDB)it2).getExecutionTimestamp()) <= 0) continue;
            it = it2;
        }
        ((TradeDB)object).setOpenTimestamp((Instant)it);
        Iterable $this$map$iv = this$0.accountExecutions;
        boolean $i$f$map = false;
        Iterable it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void accountExecution;
            AccountExecutionDB accountExecutionDB = (AccountExecutionDB)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            ExecutionDB execution = new ExecutionDB();
            execution.setTrade(trade);
            ((Collection)trade.getExecutions()).add(execution);
            execution.setSize(accountExecution.getSize());
            execution.setSettlementPrice(accountExecution.getPrice());
            execution.setSymbol(accountExecution.getSymbol());
            execution.setMultiplier(accountExecution.getMultiplier());
            XBigNum xBigNum = accountExecution.getCommission();
            if (xBigNum == null) {
                xBigNum = XBigNum.Companion.getZERO();
            }
            execution.setCommission(xBigNum);
            execution.setSettlementOffset(accountExecution.getSettlement());
            execution.updateNet();
            execution.setExecutionTimestamp(accountExecution.getExecutionTimestamp());
            execution.setAccountExecution((AccountExecutionDB)accountExecution);
            ((Collection)accountExecution.getExecutions()).add(execution);
            object.add(execution);
        }
        List executions = (List)destination$iv$iv;
        spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)trade);
        Collection $this$toTypedArray$iv = executions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new ExecutionDB[0]));
        return DB.saveAll((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
    }
}

