/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.cmd.accountexecution;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.lot.business.entity.AccountExecutionDB;
import com.xorrus.trading.lot.business.entity.ExecutionDB;
import com.xorrus.trading.lot.business.entity.StepDB;
import com.xorrus.trading.lot.business.entity.TradeDB;
import com.xorrus.trading.lot.business.event.EventCollector;
import com.xorrus.trading.lot.business.event.EventManagerKt;
import com.xorrus.trading.lot.business.event.impl.TradeUpdatedEvent;
import io.ebean.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStep;", "", "accountExecutions", "", "Lcom/xorrus/trading/lot/business/entity/AccountExecutionDB;", "step", "Lcom/xorrus/trading/lot/business/entity/StepDB;", "<init>", "(Ljava/util/List;Lcom/xorrus/trading/lot/business/entity/StepDB;)V", "getAccountExecutions", "()Ljava/util/List;", "getStep", "()Lcom/xorrus/trading/lot/business/entity/StepDB;", "execute", "", "laboftrades-business-alt"})
@SourceDebugExtension(value={"SMAP\nAssignAccountExecutionsToStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssignAccountExecutionsToStep.kt\ncom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStep\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,43:1\n1740#2,3:44\n1563#2:47\n1634#2,3:48\n1#3:51\n37#4,2:52\n*S KotlinDebug\n*F\n+ 1 AssignAccountExecutionsToStep.kt\ncom/xorrus/trading/lot/business/cmd/accountexecution/AssignAccountExecutionsToStep\n*L\n13#1:44,3\n15#1:47\n15#1:48,3\n40#1:52,2\n*E\n"})
public final class AssignAccountExecutionsToStep {
    @NotNull
    private final List<AccountExecutionDB> accountExecutions;
    @NotNull
    private final StepDB step;

    public AssignAccountExecutionsToStep(@NotNull List<AccountExecutionDB> accountExecutions, @NotNull StepDB step) {
        Intrinsics.checkNotNullParameter(accountExecutions, (String)"accountExecutions");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.accountExecutions = accountExecutions;
        this.step = step;
    }

    @NotNull
    public final List<AccountExecutionDB> getAccountExecutions() {
        return this.accountExecutions;
    }

    @NotNull
    public final StepDB getStep() {
        return this.step;
    }

    public final int execute() {
        return ((Number)EventManagerKt.collectEvents(arg_0 -> AssignAccountExecutionsToStep.execute$lambda$0(this, arg_0))).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final int execute$lambda$0(AssignAccountExecutionsToStep this$0, EventCollector $this$collectEvents) {
        Object object;
        void $this$mapTo$iv$iv;
        boolean $this$all$iv2;
        Object element$iv2;
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$collectEvents, (String)"$this$collectEvents");
            Iterable $this$all$iv2 = this$0.accountExecutions;
            boolean $i$f$all = false;
            if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv2 : $this$all$iv2) {
                    AccountExecutionDB it = (AccountExecutionDB)element$iv2;
                    boolean bl = false;
                    if (it.getExecutions().isEmpty()) continue;
                    v0 = false;
                    break block8;
                }
                v0 = $this$all$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$all$iv2) {
            String $i$f$all = "Assertion failed";
            throw new AssertionError((Object)$i$f$all);
        }
        Iterable $this$map$iv = this$0.accountExecutions;
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void accountExecution;
            AccountExecutionDB accountExecutionDB = (AccountExecutionDB)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            ExecutionDB execution = new ExecutionDB();
            execution.setTrade(this$0.step.getTrade());
            execution.setStep(this$0.step);
            execution.setSize(accountExecution.getSize());
            execution.setSettlementPrice(accountExecution.getPrice());
            XBigNum xBigNum = accountExecution.getCommission();
            if (xBigNum == null) {
                xBigNum = XBigNum.Companion.getZERO();
            }
            execution.setCommission(xBigNum);
            execution.setMultiplier(accountExecution.getMultiplier());
            execution.setSettlementOffset(accountExecution.getSettlement());
            execution.updateNet();
            execution.setExecutionTimestamp(accountExecution.getExecutionTimestamp());
            execution.setSymbol(accountExecution.getSymbol());
            execution.setAccountExecution((AccountExecutionDB)accountExecution);
            object.add(execution);
        }
        List executions = (List)destination$iv$iv;
        String[] stringArray = (String[])this$0.accountExecutions;
        object = this$0.step.getTrade();
        Iterator $i$f$map22 = stringArray.iterator();
        if (!$i$f$map22.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it = (AccountExecutionDB)$i$f$map22.next();
        boolean bl = false;
        it = (Comparable)((AccountExecutionDB)it).getExecutionTimestamp();
        while ($i$f$map22.hasNext()) {
            Object it2 = (AccountExecutionDB)$i$f$map22.next();
            $i$a$-minOf-AssignAccountExecutionsToStep$execute$1$2 = false;
            if (it.compareTo(it2 = (Comparable)((AccountExecutionDB)it2).getExecutionTimestamp()) <= 0) continue;
            it = it2;
        }
        ((TradeDB)object).setOpenTimestamp((Instant)it);
        stringArray = new String[]{"openTimestamp"};
        $this$collectEvents.event(new TradeUpdatedEvent(this$0.step.getTrade(), stringArray));
        stringArray = new SpreadBuilder(3);
        stringArray.add((Object)this$0.step);
        stringArray.add((Object)this$0.step.getTrade());
        Collection $this$toTypedArray$iv = executions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray.addSpread((Object)thisCollection$iv.toArray(new ExecutionDB[0]));
        return DB.saveAll((Collection)CollectionsKt.listOfNotNull((Object[])stringArray.toArray(new Object[stringArray.size()])));
    }
}

