/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.dbmigration.dialect;

import com.xorrus.common.dbmigration.dialect.SqlDatabaseDialect;
import com.xorrus.common.dbmigration.meta.Column;
import com.xorrus.common.dbmigration.meta.Database;
import com.xorrus.common.dbmigration.meta.Datatype;
import com.xorrus.common.dbmigration.meta.ForeignKey;
import com.xorrus.common.dbmigration.meta.Index;
import com.xorrus.common.dbmigration.meta.PrimaryKey;
import com.xorrus.common.dbmigration.meta.Table;
import com.xorrus.trading.common.bignum.XBigNum;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.sql2o.Connection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0014JD\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J(\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J(\u0010!\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0016R\u0014\u0010%\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lcom/xorrus/common/dbmigration/dialect/HyperSqlDbDialect;", "Lcom/xorrus/common/dbmigration/dialect/SqlDatabaseDialect;", "<init>", "()V", "mapToSqlType", "", "datatype", "Lcom/xorrus/common/dbmigration/meta/Datatype;", "runRenameColumn", "", "con", "Lorg/sql2o/Connection;", "database", "Lcom/xorrus/common/dbmigration/meta/Database;", "column", "Lcom/xorrus/common/dbmigration/meta/Column;", "newColumnName", "runAddForeignKey", "table", "Lcom/xorrus/common/dbmigration/meta/Table;", "foreignKeyName", "columnMappings", "", "deferrable", "", "runRemoveNotNullConstraint", "runRenamePrimaryKey", "primaryKey", "Lcom/xorrus/common/dbmigration/meta/PrimaryKey;", "primaryKeyName", "runRenameForeignKey", "foreignKey", "Lcom/xorrus/common/dbmigration/meta/ForeignKey;", "renameIndex", "index", "Lcom/xorrus/common/dbmigration/meta/Index;", "indexName", "defaultSchemaName", "getDefaultSchemaName", "()Ljava/lang/String;", "laboftrades-business-alt"})
public final class HyperSqlDbDialect
extends SqlDatabaseDialect {
    @Override
    @NotNull
    public String mapToSqlType(@NotNull Datatype datatype) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        KClass<?> kClass = datatype.getClazz();
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = "BIGINT";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = "INTEGER";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            object = "BOOLEAN";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            object = "DATE";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            object = "TIMESTAMP WITH TIME ZONE";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = datatype.getLength() != null ? "VARCHAR(" + datatype.getLength() + ")" : "LONGVARCHAR";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(XBigNum.class))) {
            if (datatype.getLength() != null) {
                if (!(datatype.getPrecision() != null)) {
                    boolean bl = false;
                    String string = "Datentyp " + datatype + " fehlt die precision-Angabe";
                    throw new IllegalArgumentException(string.toString());
                }
                object = "DECIMAL(" + datatype.getLength() + "," + datatype.getPrecision() + ")";
            } else {
                object = "DECIMAL";
            }
        } else {
            throw new IllegalStateException(("Nicht unterst\u00fctzter Datentyp f\u00fcr HyperSqlDbDialect: " + datatype).toString());
        }
        return object;
    }

    @Override
    protected void runRenameColumn(@NotNull Connection con, @NotNull Database database, @NotNull Column column, @NotNull String newColumnName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)newColumnName, (String)"newColumnName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER TABLE " + super.quoteTable(column.getTable().getTableName()) + "\n            ALTER COLUMN " + super.quoteColumn(column) + " RENAME TO " + super.quoteColumn(newColumnName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    protected void runAddForeignKey(@NotNull Connection con, @NotNull Database database, @NotNull Table table, @NotNull String foreignKeyName, @NotNull Map<Column, Column> columnMappings, boolean deferrable) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)foreignKeyName, (String)"foreignKeyName");
        Intrinsics.checkNotNullParameter(columnMappings, (String)"columnMappings");
        super.runAddForeignKey(con, database, table, foreignKeyName, columnMappings, false);
    }

    @Override
    public void runRemoveNotNullConstraint(@NotNull Connection con, @NotNull Database database, @NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        String sql = StringsKt.trimIndent((String)("\n            ALTER TABLE " + this.quoteTable(column.getTable().getTableName()) + "\n            ALTER COLUMN " + this.quoteColumn(column) + "\n            SET NULL;\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void runRenamePrimaryKey(@NotNull Connection con, @NotNull Database database, @NotNull PrimaryKey primaryKey, @NotNull String primaryKeyName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter((Object)primaryKeyName, (String)"primaryKeyName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER CONSTRAINT " + this.quotePrimaryKey(primaryKey.getPrimaryKeyName()) + " RENAME TO " + this.quotePrimaryKey(primaryKeyName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void runRenameForeignKey(@NotNull Connection con, @NotNull Database database, @NotNull ForeignKey foreignKey, @NotNull String foreignKeyName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)foreignKey, (String)"foreignKey");
        Intrinsics.checkNotNullParameter((Object)foreignKeyName, (String)"foreignKeyName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER CONSTRAINT " + this.quoteForeignKey(foreignKey.getForeignKeyName()) + " RENAME TO " + this.quoteForeignKey(foreignKeyName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void renameIndex(@NotNull Connection con, @NotNull Database database, @NotNull Index index, @NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER INDEX " + this.quoteIndex(index.getIndexName()) + " RENAME TO " + this.quoteIndex(indexName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    @NotNull
    public String getDefaultSchemaName() {
        return "PUBLIC";
    }
}

