/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber;

import korlibs.bignumber.BigIntOverflowException;
import korlibs.bignumber.CommonBigInt;
import korlibs.bignumber.UInt16ArrayZeroPad;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\b0\u0013H\u0086\bJ\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\bJ \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010 J.\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bJ,\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020\b2\b\b\u0002\u0010+\u001a\u00020\u0004J\u0016\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006."}, d2={"Lkorlibs/bignumber/UnsignedBigInt;", "", "()V", "add", "Lkorlibs/bignumber/UInt16ArrayZeroPad;", "l", "r", "addOne", "", "a", "offset", "mlen", "carry", "carriedOp", "", "out", "signedCarry", "", "op", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "index", "compare", "divRemSmall", "Lkorlibs/bignumber/UnsignedBigInt$DivRemSmall;", "value", "inplaceSmallMulAdd", "v", "vv", "mul", "stats", "Lkorlibs/bignumber/CommonBigInt$OpStats;", "mulAdd", "o", "i", "len", "k", "primitiveLeftShift", "n", "squareToLen", "x", "zlen", "z", "sub", "DivRemSmall", "kbignum"})
@SourceDebugExtension(value={"SMAP\nCommonBigInt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigInt.kt\nkorlibs/bignumber/UnsignedBigInt\n*L\n1#1,699:1\n540#1,9:700\n540#1,9:709\n540#1,9:718\n540#1,9:727\n540#1,9:736\n*S KotlinDebug\n*F\n+ 1 CommonBigInt.kt\nkorlibs/bignumber/UnsignedBigInt\n*L\n551#1:700,9\n552#1:709,9\n556#1:718,9\n561#1:727,9\n568#1:736,9\n*E\n"})
public final class UnsignedBigInt {
    @NotNull
    public static final UnsignedBigInt INSTANCE = new UnsignedBigInt();

    private UnsignedBigInt() {
    }

    public final void carriedOp(@NotNull UInt16ArrayZeroPad out, boolean signedCarry, @NotNull Function1<? super Integer, Integer> op) {
        boolean $i$f$carriedOp = false;
        int carry = 0;
        int n = out.getData().length;
        for (int n2 = 0; n2 < n; ++n2) {
            int res;
            int product = ((Number)op.invoke((Object)n2)).intValue() + carry;
            out.getData()[n2] = res = product & 0xFFFF;
            carry = signedCarry ? product >> 16 : product >>> 16;
        }
        if (carry != 0) {
            throw new IllegalStateException("Overflow in carriedOp".toString());
        }
    }

    public final void inplaceSmallMulAdd(@NotNull UInt16ArrayZeroPad v, int mul, int add) {
        int res$iv;
        int product$iv;
        int it;
        int n$iv;
        int n;
        int carry$iv;
        boolean $i$f$carriedOp;
        boolean signedCarry$iv;
        if (mul != 1) {
            UnsignedBigInt unsignedBigInt = this;
            signedCarry$iv = false;
            $i$f$carriedOp = false;
            carry$iv = 0;
            n = v.getData().length;
            for (n$iv = 0; n$iv < n; ++n$iv) {
                it = n$iv;
                boolean bl = false;
                product$iv = v.get(it) * mul + carry$iv;
                v.getData()[n$iv] = res$iv = product$iv & 0xFFFF;
                carry$iv = product$iv >>> 16;
            }
            if (carry$iv != 0) {
                throw new IllegalStateException("Overflow in carriedOp".toString());
            }
        }
        if (add != 0) {
            UnsignedBigInt this_$iv = this;
            signedCarry$iv = false;
            $i$f$carriedOp = false;
            carry$iv = 0;
            n = v.getData().length;
            for (n$iv = 0; n$iv < n; ++n$iv) {
                it = n$iv;
                boolean bl = false;
                product$iv = (it == 0 ? v.get(it) + add : v.get(it) + 0) + carry$iv;
                v.getData()[n$iv] = res$iv = product$iv & 0xFFFF;
                carry$iv = product$iv >>> 16;
            }
            if (carry$iv != 0) {
                throw new IllegalStateException("Overflow in carriedOp".toString());
            }
        }
    }

    public final void inplaceSmallMulAdd(@NotNull UInt16ArrayZeroPad v, @NotNull UInt16ArrayZeroPad vv, int mul) {
        UnsignedBigInt unsignedBigInt = this;
        boolean signedCarry$iv = false;
        boolean $i$f$carriedOp = false;
        int carry$iv = 0;
        int n = v.getData().length;
        for (int n$iv = 0; n$iv < n; ++n$iv) {
            int res$iv;
            int it = n$iv;
            boolean bl = false;
            int product$iv = v.get(it) + vv.get(it) * mul + carry$iv;
            v.getData()[n$iv] = res$iv = product$iv & 0xFFFF;
            carry$iv = product$iv >>> 16;
        }
        if (carry$iv != 0) {
            throw new IllegalStateException("Overflow in carriedOp".toString());
        }
    }

    @NotNull
    public final UInt16ArrayZeroPad add(@NotNull UInt16ArrayZeroPad l, @NotNull UInt16ArrayZeroPad r) {
        UInt16ArrayZeroPad out = new UInt16ArrayZeroPad(Math.max(l.getSize(), r.getSize()) + 1);
        UnsignedBigInt unsignedBigInt = this;
        boolean signedCarry$iv = false;
        boolean $i$f$carriedOp = false;
        int carry$iv = 0;
        int n = out.getData().length;
        for (int n$iv = 0; n$iv < n; ++n$iv) {
            int res$iv;
            int it = n$iv;
            boolean bl = false;
            int product$iv = l.get(it) + r.get(it) + carry$iv;
            out.getData()[n$iv] = res$iv = product$iv & 0xFFFF;
            carry$iv = product$iv >>> 16;
        }
        if (carry$iv != 0) {
            throw new IllegalStateException("Overflow in carriedOp".toString());
        }
        return out;
    }

    @NotNull
    public final UInt16ArrayZeroPad sub(@NotNull UInt16ArrayZeroPad l, @NotNull UInt16ArrayZeroPad r) {
        UInt16ArrayZeroPad out = new UInt16ArrayZeroPad(Math.max(l.getSize(), r.getSize()) + 1);
        UnsignedBigInt unsignedBigInt = this;
        boolean signedCarry$iv = true;
        boolean $i$f$carriedOp = false;
        int carry$iv = 0;
        int n = out.getData().length;
        for (int n$iv = 0; n$iv < n; ++n$iv) {
            int res$iv;
            int it = n$iv;
            boolean bl = false;
            int product$iv = l.get(it) - r.get(it) + carry$iv;
            out.getData()[n$iv] = res$iv = product$iv & 0xFFFF;
            carry$iv = product$iv >> 16;
        }
        if (carry$iv != 0) {
            throw new IllegalStateException("Overflow in carriedOp".toString());
        }
        return out;
    }

    @NotNull
    public final UInt16ArrayZeroPad squareToLen(@NotNull UInt16ArrayZeroPad x, int len, int zlen, @NotNull UInt16ArrayZeroPad z) {
        int lastProductLowWord = 0;
        UnsignedBigInt $this$squareToLen_u24lambda_u245 = this;
        boolean bl = false;
        int i = 0;
        for (int j = 0; j < len; ++j) {
            int piece = x.get(j);
            int product = piece * piece;
            z.set(i++, lastProductLowWord << 15 | product >>> 17);
            z.set(i++, product >>> 1);
            lastProductLowWord = product;
        }
        int offset = 1;
        for (int i2 = 0; i2 < len; ++i2) {
            int t = x.get(i2 - 1);
            this.mulAdd(z, x, offset, i2 - 1, t);
            this.addOne(z, offset - 1, i2, t);
            offset += 2;
        }
        this.primitiveLeftShift(z, zlen, 1);
        z.set(zlen - 1, z.get(zlen - 1) | x.get(len - 1) & 1);
        return z;
    }

    public static /* synthetic */ UInt16ArrayZeroPad squareToLen$default(UnsignedBigInt unsignedBigInt, UInt16ArrayZeroPad uInt16ArrayZeroPad, int n, int n2, UInt16ArrayZeroPad uInt16ArrayZeroPad2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = uInt16ArrayZeroPad.getSize();
        }
        if ((n3 & 4) != 0) {
            n2 = n * 2;
        }
        if ((n3 & 8) != 0) {
            uInt16ArrayZeroPad2 = new UInt16ArrayZeroPad(n2);
        }
        return unsignedBigInt.squareToLen(uInt16ArrayZeroPad, n, n2, uInt16ArrayZeroPad2);
    }

    public final int addOne(@NotNull UInt16ArrayZeroPad a, int offset, int mlen, int carry) {
        int n = offset + mlen;
        for (int n2 = offset; n2 < n; ++n2) {
            if (n2 != offset + mlen) continue;
            a.get(n2);
        }
        int offset2 = offset;
        int mlen2 = mlen;
        offset2 = a.getSize() - 1 - mlen2 - offset2;
        int t = a.get(offset2) + carry;
        a.set(offset2, t);
        if (t >>> 16 == 0) {
            return 0;
        }
        while (--mlen2 >= 0) {
            if (--offset2 < 0) {
                return 1;
            }
            int n3 = offset2;
            int n4 = a.get(n3);
            a.set(n3, n4 + 1);
            if (a.get(offset2) == 0) continue;
            return 0;
        }
        return 1;
    }

    public final void primitiveLeftShift(@NotNull UInt16ArrayZeroPad a, int len, int n) {
        int i;
        if (len == 0 || n == 0) {
            return;
        }
        int n2 = 16 - n;
        int c = a.get(i);
        int m = i + len - 1;
        for (i = 0; i < m; ++i) {
            int b = c;
            c = a.get(i + 1);
            a.set(i, b << n | c >>> n2);
        }
        a.set(len - 1, a.get(len - 1) << n);
    }

    public final int mulAdd(@NotNull UInt16ArrayZeroPad o, @NotNull UInt16ArrayZeroPad i, int offset, int len, int k) {
        int carry = 0;
        for (int j = 0; j < len; ++j) {
            int product = i.get(j) * k + o.get(offset + j) + carry;
            o.set(offset + j, product);
            carry = product >>> 16;
        }
        return carry;
    }

    @NotNull
    public final UInt16ArrayZeroPad mul(@NotNull UInt16ArrayZeroPad l, @NotNull UInt16ArrayZeroPad r, @Nullable CommonBigInt.OpStats stats) {
        int its = 0;
        UInt16ArrayZeroPad out = new UInt16ArrayZeroPad(l.getSize() + r.getSize() + 1);
        int n = r.getSize();
        for (int rn = 0; rn < n; ++rn) {
            int carry = 0;
            int n2 = l.getSize() + 1;
            for (int ln = 0; ln < n2; ++ln) {
                int n3 = ln + rn;
                int res = out.get(n3) + l.get(ln) * r.get(rn) + carry;
                out.set(n3, res);
                carry = res >>> 16;
                ++its;
            }
            if (carry == 0) continue;
            throw new BigIntOverflowException("carry expected to be zero at this point");
        }
        CommonBigInt.OpStats opStats = stats;
        if (opStats != null) {
            opStats.setIterations(its);
        }
        return out;
    }

    @NotNull
    public final DivRemSmall divRemSmall(@NotNull UInt16ArrayZeroPad value, int r) {
        int length = value.getSize();
        int rem = 0;
        UInt16ArrayZeroPad qq = new UInt16ArrayZeroPad(value.getSize());
        for (int n = 0; n < length; ++n) {
            int i = length - 1 - n;
            int dd = (rem << 16) + value.get(i);
            int q = dd / r;
            rem = dd - q * r;
            qq.set(i, q);
        }
        return new DivRemSmall(qq, rem);
    }

    public final int compare(@NotNull UInt16ArrayZeroPad l, @NotNull UInt16ArrayZeroPad r) {
        for (int n = Math.max(l.getSize(), r.getSize()) - 1; -1 < n; --n) {
            int vr;
            int vl = l.get(n);
            if (vl < (vr = r.get(n))) {
                return -1;
            }
            if (vl <= vr) continue;
            return 1;
        }
        return 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lkorlibs/bignumber/UnsignedBigInt$DivRemSmall;", "", "div", "Lkorlibs/bignumber/UInt16ArrayZeroPad;", "rem", "", "(Lkorlibs/bignumber/UInt16ArrayZeroPad;I)V", "getDiv", "()Lkorlibs/bignumber/UInt16ArrayZeroPad;", "getRem", "()I", "kbignum"})
    public static final class DivRemSmall {
        @NotNull
        private final UInt16ArrayZeroPad div;
        private final int rem;

        public DivRemSmall(@NotNull UInt16ArrayZeroPad div, int rem) {
            this.div = div;
            this.rem = rem;
        }

        @NotNull
        public final UInt16ArrayZeroPad getDiv() {
            return this.div;
        }

        public final int getRem() {
            return this.rem;
        }
    }
}

