/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.shared.composites;

import java.util.Objects;

public class CompositeValue<T> {
    private final int storeId;
    private final T value;

    public CompositeValue(int storeId, T value) {
        this.storeId = storeId;
        this.value = value;
    }

    public int getStoreId() {
        return this.storeId;
    }

    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        return CompositeValue.compositeHash(this.storeId, this.value.hashCode());
    }

    public static int compositeHash(int storeId, int valueHash) {
        return storeId * 31 + valueHash;
    }

    public static int valueOnlyHash(int compositeHash, int storeId) {
        return compositeHash - storeId * 31;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeValue that = (CompositeValue)o;
        return this.storeId == that.storeId && Objects.equals(this.value, that.value);
    }
}

