/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.filesystem.impl;

import com.terracottatech.offheapstore.filesystem.SeekableInputStream;
import com.terracottatech.offheapstore.filesystem.impl.OffheapFile;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OffheapInputStream
extends SeekableInputStream {
    static final ByteBuffer NULL_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final OffheapFile file;
    private ByteBuffer currentBlock;
    private int currentBlockIndex;
    private final int BLOCK_SIZE;

    OffheapInputStream(OffheapFile file, int blockSize) throws IOException {
        this.BLOCK_SIZE = blockSize;
        this.file = file;
        if (file.length() / (long)this.BLOCK_SIZE > Integer.MAX_VALUE) {
            throw new IOException("OffHeapFileInputStream too large length=" + file.length());
        }
        this.resetBlocks();
    }

    private void resetBlocks() {
        this.currentBlockIndex = -1;
        this.currentBlock = NULL_BUFFER;
    }

    @Override
    public void close() throws IOException {
        this.resetBlocks();
        this.file.streamClosed(false);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public int read() throws IOException {
        return this.ensureCapacity() ? this.currentBlock.get() & 0xFF : -1;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            this.ensureCapacity();
            int lenToRead = Math.min(len, this.currentBlock.remaining());
            this.currentBlock.get(b, offset, lenToRead);
            len -= lenToRead;
            offset += lenToRead;
        }
    }

    private boolean ensureCapacity() throws IOException {
        if (!this.currentBlock.hasRemaining()) {
            if (this.currentBlockIndex >= this.file.numBlocks() - 1) {
                return false;
            }
            this.currentBlock = this.getNextBlockToRead();
        }
        return true;
    }

    private ByteBuffer getNextBlockToRead() throws IOException {
        ByteBuffer buf = this.file.getBlockToRead(++this.currentBlockIndex);
        return buf;
    }

    private ByteBuffer getCurrentBlockToRead() throws IOException {
        ByteBuffer buf = this.file.getBlockToRead(this.currentBlockIndex);
        return buf;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.currentBlockIndex < 0 ? 0L : (long)this.currentBlockIndex * (long)this.BLOCK_SIZE + (long)this.currentBlock.position();
    }

    @Override
    public void seek(long pos) throws IOException, EOFException {
        if (pos < 0L) {
            throw new IOException("Seek position cannot be negative");
        }
        long newIndexPos = pos / (long)this.BLOCK_SIZE;
        int bufferPosition = (int)(pos % (long)this.BLOCK_SIZE);
        if (newIndexPos >= (long)this.file.numBlocks()) {
            this.resetBlocks();
        } else {
            if ((long)this.currentBlockIndex != newIndexPos) {
                this.currentBlockIndex = (int)newIndexPos;
                this.currentBlock = this.getCurrentBlockToRead();
            }
            if (bufferPosition > this.currentBlock.limit()) {
                throw new EOFException("seek past EOF");
            }
            this.currentBlock.position(bufferPosition);
        }
    }

    public String toString() {
        return "OffHeapFileInputStream@" + System.identityHashCode(this);
    }
}

