/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.action.InvalidatingAction;
import com.terracottatech.frs.action.SimpleInvalidatingAction;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

class RemoveAction
implements InvalidatingAction {
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            long invalidatedLsn = ByteBufferUtils.getLong(buffers);
            return new SimpleInvalidatingAction(Collections.singleton(invalidatedLsn));
        }
    };
    private final ObjectManager<ByteBuffer, ByteBuffer, ?> objectManager;
    private final Compactor compactor;
    private final ByteBuffer id;
    private final ByteBuffer key;
    private final long invalidatedLsn;

    RemoveAction(ObjectManager<ByteBuffer, ByteBuffer, ?> objectManager, Compactor compactor, ByteBuffer id, ByteBuffer key, boolean recovery) {
        this.objectManager = objectManager;
        this.compactor = compactor;
        this.id = id;
        this.key = key;
        this.invalidatedLsn = objectManager.getLsn(id, key);
        if (this.invalidatedLsn == -1L && recovery) {
            throw new IllegalStateException("Removing a non-existent key is unsupported during recovery.");
        }
    }

    @Override
    public Set<Long> getInvalidatedLsns() {
        return Collections.singleton(this.invalidatedLsn);
    }

    @Override
    public void record(long lsn) {
        this.objectManager.remove(this.id, this.key);
        if (this.invalidatedLsn != -1L) {
            this.compactor.generatedGarbage(this.invalidatedLsn);
        }
    }

    @Override
    public void replay(long lsn) {
    }

    @Override
    public ByteBuffer[] getPayload(ActionCodec codec) {
        ByteBuffer header = ByteBuffer.allocate(8);
        header.putLong(this.invalidatedLsn).flip();
        return new ByteBuffer[]{header};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveAction that = (RemoveAction)o;
        return this.id.equals(that.id) && this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

