/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.postgres;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.Platform;
import io.ebean.config.PlatformConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.platform.postgres.PostgresDbEncrypt;
import io.ebean.platform.postgres.PostgresHistorySupport;
import io.ebean.platform.postgres.PostgresSequenceIdGenerator;
import javax.sql.DataSource;

public class PostgresPlatform
extends DatabasePlatform {
    private static final String SKIP_LOCKED = " skip locked";
    private static final String NO_WAIT = " nowait";
    private static final String FOR_UPDATE = " for update";
    private static final String FOR_NO_KEY_UPDATE = " for no key update";
    private static final String FOR_SHARE = " for share";
    private static final String FOR_KEY_SHARE = " for key share";
    private boolean forUpdateNoKey;

    public PostgresPlatform() {
        this.platform = Platform.POSTGRES;
        this.maxInBinding = 32000;
        this.supportsNativeIlike = true;
        this.supportsDeleteTableAlias = true;
        this.selectCountWithAlias = true;
        this.blobDbType = -4;
        this.clobDbType = 12;
        this.nativeUuidType = true;
        this.autoCommitFalseOnFindIterate = true;
        this.truncateTable = "truncate table %s cascade";
        this.dbEncrypt = new PostgresDbEncrypt();
        this.historySupport = new PostgresHistorySupport();
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.dbIdentity.setSupportsIdentity(true);
        this.dbDefaultValue.setNow("current_timestamp");
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock(new String[]{"55P03"}).addDuplicateKey(new String[]{"23505"}).addDataIntegrity(new String[]{"23000", "23502", "23503", "23514"}).addSerializableConflict(new String[]{"40001"}).build();
        this.openQuote = "\"";
        this.closeQuote = "\"";
        DbPlatformType dbTypeText = new DbPlatformType("text", false);
        DbPlatformType dbBytea = new DbPlatformType("bytea", false);
        this.dbTypeMap.put(DbType.VARCHAR, new DbPlatformType("varchar", 0, 0xA00000, dbTypeText));
        this.dbTypeMap.put(DbType.UUID, new DbPlatformType("uuid", false));
        this.dbTypeMap.put(DbType.INET, new DbPlatformType("inet", false));
        this.dbTypeMap.put(DbType.CIDR, new DbPlatformType("cidr", false));
        this.dbTypeMap.put(DbType.HSTORE, new DbPlatformType("hstore", false));
        this.dbTypeMap.put(DbType.JSON, new DbPlatformType("json", false));
        this.dbTypeMap.put(DbType.JSONB, new DbPlatformType("jsonb", false));
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("integer", false));
        this.dbTypeMap.put(DbType.DOUBLE, new DbPlatformType("float"));
        this.dbTypeMap.put(DbType.TINYINT, new DbPlatformType("smallint"));
        this.dbTypeMap.put(DbType.TIMESTAMP, new DbPlatformType("timestamptz"));
        this.dbTypeMap.put(DbType.LOCALDATETIME, new DbPlatformType("timestamp"));
        this.dbTypeMap.put(DbType.BINARY, dbBytea);
        this.dbTypeMap.put(DbType.VARBINARY, dbBytea);
        this.dbTypeMap.put(DbType.BLOB, dbBytea);
        this.dbTypeMap.put(DbType.CLOB, dbTypeText);
        this.dbTypeMap.put(DbType.LONGVARBINARY, dbBytea);
        this.dbTypeMap.put(DbType.LONGVARCHAR, dbTypeText);
        this.dbTypeMap.put(DbType.VECTOR, new DbPlatformType("vector", 512, 2000, null));
        this.dbTypeMap.put(DbType.VECTOR_HALF, new DbPlatformType("halfvec", 512, 4000, null));
        this.dbTypeMap.put(DbType.VECTOR_BIT, new DbPlatformType("bit", 512, 64000, null));
        this.dbTypeMap.put(DbType.VECTOR_SPARSE, new DbPlatformType("sparsevec", 512, 64000, null));
    }

    public void configure(PlatformConfig config) {
        super.configure(config);
        this.forUpdateNoKey = config.isForUpdateNoKey();
    }

    protected void addGeoTypes(int srid) {
        this.dbTypeMap.put(DbType.POINT, this.geoType("point", srid));
        this.dbTypeMap.put(DbType.POLYGON, this.geoType("polygon", srid));
        this.dbTypeMap.put(DbType.LINESTRING, this.geoType("linestring", srid));
        this.dbTypeMap.put(DbType.MULTIPOINT, this.geoType("multipoint", srid));
        this.dbTypeMap.put(DbType.MULTILINESTRING, this.geoType("multilinestring", srid));
        this.dbTypeMap.put(DbType.MULTIPOLYGON, this.geoType("multipolygon", srid));
    }

    private DbPlatformType geoType(String type, int srid) {
        return new DbPlatformType("geometry(" + type + "," + srid + ")");
    }

    public boolean nativeArrayType() {
        return true;
    }

    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new PostgresSequenceIdGenerator(be, ds, seqName, this.sequenceBatchSize);
    }

    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        switch (lockWait) {
            case SKIPLOCKED: {
                return sql + this.lock(lockType) + SKIP_LOCKED;
            }
            case NOWAIT: {
                return sql + this.lock(lockType) + NO_WAIT;
            }
        }
        return sql + this.lock(lockType);
    }

    private String lock(Query.LockType lockType) {
        switch (lockType) {
            case UPDATE: {
                return FOR_UPDATE;
            }
            case NO_KEY_UPDATE: {
                return FOR_NO_KEY_UPDATE;
            }
            case SHARE: {
                return FOR_SHARE;
            }
            case KEY_SHARE: {
                return FOR_KEY_SHARE;
            }
            case DEFAULT: {
                return this.forUpdateNoKey ? FOR_NO_KEY_UPDATE : FOR_UPDATE;
            }
        }
        return FOR_UPDATE;
    }
}

