/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.LocalMigrationResource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;

final class LocalUriMigrationResource
extends LocalMigrationResource {
    private final URL resource;
    private final int checksum;

    LocalUriMigrationResource(MigrationVersion version, String location, URL resource, int checksum) {
        super(version, location);
        this.resource = resource;
        this.checksum = checksum;
    }

    public int checksum() {
        return this.checksum;
    }

    @Override
    public String content() {
        String string;
        InputStreamReader reader = new InputStreamReader(this.resource.openStream());
        try {
            StringWriter writer = new StringWriter(1024);
            reader.transferTo(writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(this.missingOpensMessage(), e);
            }
        }
        reader.close();
        return string;
    }

    private String missingOpensMessage() {
        return "NPE reading DB migration content at [" + this.location + "] Probably missing an 'opens dbmigration;' in module-info.java";
    }
}

