/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.jackson.jsonnode;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.PostgresHelper;
import io.ebean.jackson.jsonnode.ScalarTypeJsonNode;
import java.sql.SQLException;

abstract class ScalarTypeJsonNodePostgres
extends ScalarTypeJsonNode {
    final ObjectMapper objectMapper;
    final String postgresType;

    ScalarTypeJsonNodePostgres(ObjectMapper objectMapper, int jdbcType, String postgresType) {
        super(objectMapper, jdbcType);
        this.objectMapper = objectMapper;
        this.postgresType = postgresType;
    }

    @Override
    public void bind(DataBinder binder, JsonNode value) throws SQLException {
        String rawJson = value == null ? null : this.formatValue(value);
        binder.setObject(PostgresHelper.asObject((String)this.postgresType, (String)rawJson));
    }

    static final class JSONB
    extends ScalarTypeJsonNodePostgres {
        public JSONB(ObjectMapper objectMapper) {
            super(objectMapper, 5002, "jsonb");
        }
    }

    static final class JSON
    extends ScalarTypeJsonNodePostgres {
        public JSON(ObjectMapper objectMapper) {
            super(objectMapper, 5001, "json");
        }
    }
}

