/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import io.ebean.datasource.ConfigPropertiesHelper;
import io.ebean.datasource.DataSourceAlert;
import io.ebean.datasource.DataSourceBuilder;
import io.ebean.datasource.DataSourceConfigurationException;
import io.ebean.datasource.DataSourceFactory;
import io.ebean.datasource.DataSourcePool;
import io.ebean.datasource.DataSourcePoolListener;
import io.ebean.datasource.InitDatabase;
import io.ebean.datasource.NewConnectionInitializer;
import io.ebean.datasource.PostgresInitDatabase;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class DataSourceConfig
implements DataSourceBuilder.Settings {
    private static final int UNSET = -1;
    private static final String POSTGRES = "postgres";
    private String name = "";
    private String readOnlyUrl;
    private String url;
    private String username;
    private String password;
    private String password2;
    private String schema;
    private String catalog;
    private Driver driver;
    private Class<? extends Driver> driverClass;
    private String driverClassName;
    private DataSource dataSource;
    private InitDatabase initDatabase;
    private String platform;
    private String ownerUsername;
    private String ownerPassword;
    private int minConnections = -1;
    private int initialConnections = -1;
    private int maxConnections = -1;
    private int isolationLevel = 2;
    private boolean autoCommit;
    private boolean readOnly;
    private String heartbeatSql;
    private int heartbeatFreqSecs = 30;
    private int heartbeatTimeoutSeconds = 30;
    private int heartbeatMaxPoolExhaustedCount = 10;
    private boolean captureStackTrace;
    private int maxStackTraceSize = 5;
    private int leakTimeMinutes = 30;
    private int maxInactiveTimeSecs = 300;
    private int maxAgeMinutes = 0;
    private int trimPoolFreqSecs = 59;
    private int pstmtCacheSize = 100;
    private int cstmtCacheSize = 20;
    private int waitTimeoutMillis = 1000;
    private String poolListener;
    private boolean offline;
    private boolean failOnStart = true;
    private Map<String, String> customProperties;
    private List<String> initSql;
    private DataSourceAlert alert;
    private DataSourcePoolListener listener;
    private NewConnectionInitializer connectionInitializer;
    private Properties clientInfo;
    private String applicationName;
    private boolean shutdownOnJvmExit;
    private boolean validateOnHeartbeat = !System.getenv().containsKey("LAMBDA_TASK_ROOT");
    private boolean enforceCleanClose;

    @Override
    public DataSourceBuilder.Settings settings() {
        return this;
    }

    @Override
    public DataSourceBuilder apply(Consumer<DataSourceBuilder.Settings> apply) {
        apply.accept(this);
        return this;
    }

    @Override
    public DataSourceConfig copy() {
        DataSourceConfig copy = new DataSourceConfig();
        copy.initDatabase = this.initDatabase;
        copy.url = this.url;
        copy.readOnlyUrl = this.readOnlyUrl;
        copy.username = this.username;
        copy.password = this.password;
        copy.password2 = this.password2;
        copy.schema = this.schema;
        copy.catalog = this.catalog;
        copy.platform = this.platform;
        copy.ownerUsername = this.ownerUsername;
        copy.ownerPassword = this.ownerPassword;
        copy.driver = this.driver;
        copy.driverClass = this.driverClass;
        copy.driverClassName = this.driverClassName;
        copy.applicationName = this.applicationName;
        copy.minConnections = this.minConnections;
        copy.initialConnections = this.initialConnections;
        copy.maxConnections = this.maxConnections;
        copy.isolationLevel = this.isolationLevel;
        copy.autoCommit = this.autoCommit;
        copy.readOnly = this.readOnly;
        copy.heartbeatSql = this.heartbeatSql;
        copy.heartbeatFreqSecs = this.heartbeatFreqSecs;
        copy.heartbeatTimeoutSeconds = this.heartbeatTimeoutSeconds;
        copy.captureStackTrace = this.captureStackTrace;
        copy.maxStackTraceSize = this.maxStackTraceSize;
        copy.leakTimeMinutes = this.leakTimeMinutes;
        copy.maxInactiveTimeSecs = this.maxInactiveTimeSecs;
        copy.maxAgeMinutes = this.maxAgeMinutes;
        copy.trimPoolFreqSecs = this.trimPoolFreqSecs;
        copy.pstmtCacheSize = this.pstmtCacheSize;
        copy.cstmtCacheSize = this.cstmtCacheSize;
        copy.waitTimeoutMillis = this.waitTimeoutMillis;
        copy.poolListener = this.poolListener;
        copy.offline = this.offline;
        copy.failOnStart = this.failOnStart;
        copy.shutdownOnJvmExit = this.shutdownOnJvmExit;
        copy.validateOnHeartbeat = this.validateOnHeartbeat;
        if (this.customProperties != null) {
            copy.customProperties = new LinkedHashMap<String, String>(this.customProperties);
        }
        if (this.clientInfo != null) {
            copy.clientInfo = new Properties();
            copy.clientInfo.putAll((Map<?, ?>)this.clientInfo);
        }
        if (this.initSql != null) {
            copy.initSql = new ArrayList<String>(this.initSql);
        }
        copy.alert = this.alert;
        copy.listener = this.listener;
        copy.enforceCleanClose = this.enforceCleanClose;
        return copy;
    }

    @Override
    public DataSourceConfig setDefaults(DataSourceBuilder builder) {
        List<String> otherInitSql;
        Properties otherClientInfo;
        Map<String, String> otherCustomProps;
        DataSourceBuilder.Settings other = builder.settings();
        if (this.driver == null) {
            this.driver = other.driver();
        }
        if (this.driverClass == null) {
            this.driverClass = other.driverClass();
        }
        if (this.driverClassName == null) {
            this.driverClassName = other.getDriver();
        }
        if (this.url == null) {
            this.url = other.getUrl();
        }
        if (this.username == null) {
            this.username = other.getUsername();
        }
        if (this.password == null) {
            this.password = other.getPassword();
        }
        if (this.password2 == null) {
            this.password2 = other.getPassword2();
        }
        if (this.schema == null) {
            this.schema = other.getSchema();
        }
        if (this.catalog == null) {
            this.catalog = other.catalog();
        }
        if (this.minConnections == -1) {
            this.minConnections = other.getMinConnections();
        }
        if (this.initialConnections == -1) {
            this.initialConnections = other.getInitialConnections();
        }
        if (this.maxConnections == -1) {
            this.maxConnections = other.getMaxConnections();
        }
        if (!this.shutdownOnJvmExit && other.isShutdownOnJvmExit()) {
            this.shutdownOnJvmExit = true;
        }
        if (this.validateOnHeartbeat && !other.isValidateOnHeartbeat()) {
            this.validateOnHeartbeat = false;
        }
        if (this.customProperties == null && (otherCustomProps = other.getCustomProperties()) != null && !otherCustomProps.isEmpty()) {
            this.customProperties = new LinkedHashMap<String, String>(otherCustomProps);
        }
        if (this.clientInfo == null && (otherClientInfo = other.getClientInfo()) != null && !otherClientInfo.isEmpty()) {
            this.clientInfo = new Properties();
            this.clientInfo.putAll((Map<?, ?>)otherClientInfo);
        }
        if (this.initSql == null && (otherInitSql = other.getInitSql()) != null && !otherInitSql.isEmpty()) {
            this.initSql = new ArrayList<String>(otherInitSql);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.url == null && this.driverClassName == null && this.username == null && this.password == null;
    }

    @Override
    public DataSourcePool build() {
        return DataSourceFactory.create(this.name, this);
    }

    @Override
    public DataSourceConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public DataSourceConfig dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public DataSourceConfig setApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public DataSourceConfig setClientInfo(Properties clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @Override
    public String getReadOnlyUrl() {
        return this.readOnlyUrl;
    }

    @Override
    public DataSourceConfig setReadOnlyUrl(String readOnlyUrl) {
        this.readOnlyUrl = readOnlyUrl;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public DataSourceConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public DataSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public DataSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String getPassword2() {
        return this.password2;
    }

    @Override
    public DataSourceConfig setPassword2(String password2) {
        this.password2 = password2;
        return this;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public DataSourceConfig setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public DataSourceConfig catalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    @Override
    public String getDriver() {
        return this.driverClassName;
    }

    @Override
    public DataSourceConfig setDriver(String driver) {
        this.driverClassName = driver;
        return this;
    }

    @Override
    public DataSourceBuilder driver(Class<? extends Driver> driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    @Override
    public DataSourceBuilder driver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public Class<? extends Driver> driverClass() {
        return this.driverClass;
    }

    @Override
    public Driver driver() {
        return this.driver;
    }

    @Override
    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public DataSourceConfig setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    @Override
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public DataSourceConfig setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public DataSourceConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public int getMinConnections() {
        return this.minConnections == -1 ? 2 : this.minConnections;
    }

    @Override
    public DataSourceConfig setMinConnections(int minConnections) {
        this.minConnections = minConnections;
        return this;
    }

    @Override
    public int getInitialConnections() {
        int min = this.getMinConnections();
        int max = this.getMaxConnections();
        return this.initialConnections == -1 ? min : Math.min(Math.max(min, this.initialConnections), max);
    }

    @Override
    public DataSourceConfig initialConnections(int initialConnections) {
        this.initialConnections = initialConnections;
        return this;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections == -1 ? 200 : this.maxConnections;
    }

    @Override
    public DataSourceConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Override
    public DataSourceAlert getAlert() {
        return this.alert;
    }

    @Override
    public DataSourceConfig setAlert(DataSourceAlert alert) {
        this.alert = alert;
        return this;
    }

    @Override
    public DataSourcePoolListener getListener() {
        return this.listener;
    }

    @Override
    public DataSourceConfig setListener(DataSourcePoolListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public NewConnectionInitializer getConnectionInitializer() {
        return this.connectionInitializer;
    }

    @Override
    public DataSourceBuilder connectionInitializer(NewConnectionInitializer connectionInitializer) {
        this.connectionInitializer = connectionInitializer;
        return this;
    }

    @Override
    public DataSourceBuilder defaultConnectionInitializer(NewConnectionInitializer defaultInitializer) {
        if (this.connectionInitializer == null && defaultInitializer != null) {
            this.connectionInitializer = defaultInitializer;
        }
        return this;
    }

    @Override
    public String getHeartbeatSql() {
        return this.heartbeatSql;
    }

    @Override
    public DataSourceConfig setHeartbeatSql(String heartbeatSql) {
        this.heartbeatSql = heartbeatSql;
        return this;
    }

    @Override
    public int getHeartbeatFreqSecs() {
        return this.heartbeatFreqSecs;
    }

    @Override
    public DataSourceConfig setHeartbeatFreqSecs(int heartbeatFreqSecs) {
        this.heartbeatFreqSecs = heartbeatFreqSecs;
        return this;
    }

    @Override
    public int getHeartbeatTimeoutSeconds() {
        return this.heartbeatTimeoutSeconds;
    }

    @Override
    public DataSourceConfig setHeartbeatTimeoutSeconds(int heartbeatTimeoutSeconds) {
        this.heartbeatTimeoutSeconds = heartbeatTimeoutSeconds;
        return this;
    }

    @Override
    public int getHeartbeatMaxPoolExhaustedCount() {
        return this.heartbeatMaxPoolExhaustedCount;
    }

    @Override
    public DataSourceBuilder heartbeatMaxPoolExhaustedCount(int count) {
        this.heartbeatMaxPoolExhaustedCount = count;
        return this;
    }

    @Override
    public boolean isCaptureStackTrace() {
        return this.captureStackTrace;
    }

    @Override
    public DataSourceConfig setCaptureStackTrace(boolean captureStackTrace) {
        this.captureStackTrace = captureStackTrace;
        return this;
    }

    @Override
    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    @Override
    public DataSourceConfig setMaxStackTraceSize(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
        return this;
    }

    @Override
    public int getLeakTimeMinutes() {
        return this.leakTimeMinutes;
    }

    @Override
    public DataSourceConfig setLeakTimeMinutes(int leakTimeMinutes) {
        this.leakTimeMinutes = leakTimeMinutes;
        return this;
    }

    @Override
    public int getPstmtCacheSize() {
        return this.pstmtCacheSize;
    }

    @Override
    public DataSourceConfig setPstmtCacheSize(int pstmtCacheSize) {
        this.pstmtCacheSize = pstmtCacheSize;
        return this;
    }

    @Override
    public int getCstmtCacheSize() {
        return this.cstmtCacheSize;
    }

    @Override
    public DataSourceConfig setCstmtCacheSize(int cstmtCacheSize) {
        this.cstmtCacheSize = cstmtCacheSize;
        return this;
    }

    @Override
    public int getWaitTimeoutMillis() {
        return this.waitTimeoutMillis;
    }

    @Override
    public DataSourceConfig setWaitTimeoutMillis(int waitTimeoutMillis) {
        this.waitTimeoutMillis = waitTimeoutMillis;
        return this;
    }

    @Override
    public int getMaxInactiveTimeSecs() {
        return this.maxInactiveTimeSecs;
    }

    @Override
    public int getMaxAgeMinutes() {
        return this.maxAgeMinutes;
    }

    @Override
    public DataSourceConfig setMaxAgeMinutes(int maxAgeMinutes) {
        this.maxAgeMinutes = maxAgeMinutes;
        return this;
    }

    @Override
    public DataSourceConfig setMaxInactiveTimeSecs(int maxInactiveTimeSecs) {
        this.maxInactiveTimeSecs = maxInactiveTimeSecs;
        return this;
    }

    @Override
    public int getTrimPoolFreqSecs() {
        return this.trimPoolFreqSecs;
    }

    @Override
    public DataSourceConfig setTrimPoolFreqSecs(int trimPoolFreqSecs) {
        this.trimPoolFreqSecs = trimPoolFreqSecs;
        return this;
    }

    @Override
    public String getPoolListener() {
        return this.poolListener;
    }

    @Override
    public DataSourceConfig setPoolListener(String poolListener) {
        this.poolListener = poolListener;
        return this;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public boolean isFailOnStart() {
        return this.failOnStart;
    }

    @Override
    public DataSourceConfig setFailOnStart(boolean failOnStart) {
        this.failOnStart = failOnStart;
        return this;
    }

    @Override
    public DataSourceConfig setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    @Override
    public List<String> getInitSql() {
        return this.initSql;
    }

    @Override
    public DataSourceConfig setInitSql(List<String> initSql) {
        this.initSql = initSql;
        return this;
    }

    @Override
    public DataSourceConfig setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    @Override
    public DataSourceConfig addProperty(String key, String value) {
        if (this.customProperties == null) {
            this.customProperties = new LinkedHashMap<String, String>();
        }
        this.customProperties.put(key, value);
        return this;
    }

    @Override
    public DataSourceConfig addProperty(String key, boolean value) {
        return this.addProperty(key, Boolean.toString(value));
    }

    @Override
    public DataSourceConfig addProperty(String key, int value) {
        return this.addProperty(key, Integer.toString(value));
    }

    @Override
    public String getOwnerUsername() {
        return this.ownerUsername;
    }

    @Override
    public DataSourceConfig setOwnerUsername(String ownerUsername) {
        this.ownerUsername = ownerUsername;
        return this;
    }

    @Override
    public String getOwnerPassword() {
        return this.ownerPassword;
    }

    @Override
    public DataSourceConfig setOwnerPassword(String ownerPassword) {
        this.ownerPassword = ownerPassword;
        return this;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public DataSourceConfig setPlatform(String platform) {
        this.platform = platform;
        if (this.initDatabase != null) {
            this.setInitDatabaseForPlatform(platform);
        }
        return this;
    }

    @Override
    public InitDatabase getInitDatabase() {
        return this.initDatabase;
    }

    @Override
    public DataSourceConfig setInitDatabase(InitDatabase initDatabase) {
        this.initDatabase = initDatabase;
        return this;
    }

    @Override
    public DataSourceConfig setInitDatabaseForPlatform(String platform) {
        if (platform != null && POSTGRES.equalsIgnoreCase(platform)) {
            this.initDatabase = new PostgresInitDatabase();
        }
        return this;
    }

    @Override
    public boolean useInitDatabase() {
        if (this.ownerUsername != null && this.ownerPassword != null) {
            if (this.initDatabase == null) {
                this.initDatabase = new PostgresInitDatabase();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isShutdownOnJvmExit() {
        return this.shutdownOnJvmExit;
    }

    @Override
    public DataSourceConfig shutdownOnJvmExit(boolean shutdownOnJvmExit) {
        this.shutdownOnJvmExit = shutdownOnJvmExit;
        return this;
    }

    @Override
    public boolean isValidateOnHeartbeat() {
        return this.validateOnHeartbeat;
    }

    @Override
    public DataSourceConfig validateOnHeartbeat(boolean validateOnHeartbeat) {
        this.validateOnHeartbeat = validateOnHeartbeat;
        return this;
    }

    @Override
    public DataSourceConfig load(Properties properties) {
        return this.load(properties, null);
    }

    @Override
    public DataSourceConfig load(Properties properties, String prefix) {
        this.loadSettings(new ConfigPropertiesHelper(prefix, null, properties));
        return this;
    }

    @Override
    public DataSourceConfig loadSettings(Properties properties, String poolName) {
        this.loadSettings(new ConfigPropertiesHelper("datasource", poolName, properties));
        return this;
    }

    private void loadSettings(ConfigPropertiesHelper properties) {
        String infoProperties;
        this.username = properties.get("username", this.username);
        this.password = properties.get("password", this.password);
        this.password2 = properties.get("password2", this.password2);
        this.schema = properties.get("schema", this.schema);
        this.catalog = properties.get("catalog", this.catalog);
        this.platform = properties.get("platform", this.platform);
        this.ownerUsername = properties.get("ownerUsername", this.ownerUsername);
        this.ownerPassword = properties.get("ownerPassword", this.ownerPassword);
        if (this.initDatabase == null && this.platform != null) {
            this.setInitDatabaseForPlatform(this.platform);
        }
        this.applicationName = properties.get("applicationName", this.applicationName);
        this.driverClassName = properties.get("driver", properties.get("databaseDriver", this.driverClassName));
        this.readOnlyUrl = properties.get("readOnlyUrl", this.readOnlyUrl);
        this.url = properties.get("url", properties.get("databaseUrl", this.url));
        this.autoCommit = properties.getBoolean("autoCommit", this.autoCommit);
        this.readOnly = properties.getBoolean("readOnly", this.readOnly);
        this.captureStackTrace = properties.getBoolean("captureStackTrace", this.captureStackTrace);
        this.maxStackTraceSize = properties.getInt("maxStackTraceSize", this.maxStackTraceSize);
        this.leakTimeMinutes = properties.getInt("leakTimeMinutes", this.leakTimeMinutes);
        this.maxInactiveTimeSecs = properties.getInt("maxInactiveTimeSecs", this.maxInactiveTimeSecs);
        this.trimPoolFreqSecs = properties.getInt("trimPoolFreqSecs", this.trimPoolFreqSecs);
        this.maxAgeMinutes = properties.getInt("maxAgeMinutes", this.maxAgeMinutes);
        this.minConnections = properties.getInt("minConnections", this.minConnections);
        this.initialConnections = properties.getInt("initialConnections", this.initialConnections);
        this.maxConnections = properties.getInt("maxConnections", this.maxConnections);
        this.pstmtCacheSize = properties.getInt("pstmtCacheSize", this.pstmtCacheSize);
        this.cstmtCacheSize = properties.getInt("cstmtCacheSize", this.cstmtCacheSize);
        this.waitTimeoutMillis = properties.getInt("waitTimeout", this.waitTimeoutMillis);
        this.heartbeatSql = properties.get("heartbeatSql", this.heartbeatSql);
        this.heartbeatTimeoutSeconds = properties.getInt("heartbeatTimeoutSeconds", this.heartbeatTimeoutSeconds);
        this.poolListener = properties.get("poolListener", this.poolListener);
        this.offline = properties.getBoolean("offline", this.offline);
        this.shutdownOnJvmExit = properties.getBoolean("shutdownOnJvmExit", this.shutdownOnJvmExit);
        this.validateOnHeartbeat = properties.getBoolean("validateOnHeartbeat", this.validateOnHeartbeat);
        this.enforceCleanClose = properties.getBoolean("enforceCleanClose", this.enforceCleanClose);
        String isoLevel = properties.get("isolationLevel", this._isolationLevel(this.isolationLevel));
        this.isolationLevel = this._isolationLevel(isoLevel);
        String sql = properties.get("initSql", null);
        if (sql != null && !sql.isEmpty()) {
            if (this.initSql == null) {
                this.initSql = new ArrayList<String>();
            }
            this.parseSql(sql, this.initSql);
        }
        this.failOnStart = properties.getBoolean("failOnStart", this.failOnStart);
        String customProperties = properties.get("customProperties", null);
        if (customProperties != null && !customProperties.isEmpty()) {
            if (this.customProperties == null) {
                this.customProperties = new LinkedHashMap<String, String>();
            }
            this.parseCustom(customProperties, this.customProperties);
        }
        if ((infoProperties = properties.get("clientInfo", null)) != null && !infoProperties.isEmpty()) {
            if (this.clientInfo == null) {
                this.clientInfo = new Properties();
            }
            this.parseCustom(infoProperties, this.clientInfo);
        }
    }

    void parseSql(String sql, List<String> target) {
        if (sql != null) {
            String[] queries;
            String splitter = ";";
            if (sql.toLowerCase().startsWith("delimiter $$")) {
                sql = sql.substring("delimiter $$".length());
                splitter = "\\$\\$";
            }
            for (String query : queries = sql.split(splitter)) {
                if ((query = query.trim()).isEmpty()) continue;
                target.add(query);
            }
        }
    }

    void parseCustom(String customProperties, Map target) {
        String[] pairs;
        for (String pair : pairs = customProperties.split(";")) {
            String[] split = pair.split("=");
            if (split.length != 2) continue;
            target.put(split[0], split[1]);
        }
    }

    @Override
    public DataSourceBuilder enforceCleanClose(boolean enforceCleanClose) {
        this.enforceCleanClose = enforceCleanClose;
        return this;
    }

    @Override
    public boolean enforceCleanClose() {
        return this.enforceCleanClose;
    }

    private String _isolationLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }

    private int _isolationLevel(String level) {
        if ((level = level.toUpperCase()).startsWith("TRANSACTION")) {
            level = level.substring("TRANSACTION".length());
        }
        if ("NONE".equalsIgnoreCase(level = level.replace("_", ""))) {
            return 0;
        }
        if ("READCOMMITTED".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("READUNCOMMITTED".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("REPEATABLEREAD".equalsIgnoreCase(level)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(level)) {
            return 8;
        }
        throw new RuntimeException("Transaction Isolation level [" + level + "] is not known.");
    }

    @Override
    public Properties connectionProperties() {
        if (this.username == null) {
            throw new DataSourceConfigurationException("DataSource user is not set?");
        }
        if (this.password == null) {
            throw new DataSourceConfigurationException("DataSource password is null?");
        }
        Properties connectionProps = new Properties();
        connectionProps.setProperty("user", this.username);
        connectionProps.setProperty("password", this.password);
        if (this.customProperties != null) {
            for (Map.Entry<String, String> entry : this.customProperties.entrySet()) {
                connectionProps.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return connectionProps;
    }

    public long validateStaleMillis() {
        if (this.validateOnHeartbeat) {
            return 0L;
        }
        return (long)(this.maxInactiveTimeSecs + this.trimPoolFreqSecs) * 1000L;
    }
}

