/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.ConnectionPool;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ExecutorFactory {
    ExecutorFactory() {
    }

    static ExecutorService newExecutor() {
        return Executors.newSingleThreadExecutor(ExecutorFactory.factory());
    }

    private static ThreadFactory factory() {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("datasource.reaper");
            return thread;
        };
    }

    static ConnectionPool.Heartbeat newHeartBeat(ConnectionPool pool, int freqMillis) {
        Timer timer = new Timer(ExecutorFactory.nm(pool.name()), true);
        timer.scheduleAtFixedRate((TimerTask)new HeartbeatTask(pool), freqMillis, (long)freqMillis);
        return new TimerHeartbeat(timer);
    }

    private static String nm(String poolName) {
        return poolName.isEmpty() ? "datasource.heartbeat" : "datasource." + poolName + ".heartbeat";
    }

    private static final class HeartbeatTask
    extends TimerTask {
        private final ConnectionPool pool;

        private HeartbeatTask(ConnectionPool pool) {
            this.pool = pool;
        }

        @Override
        public void run() {
            this.pool.heartbeat();
        }
    }

    private static final class TimerHeartbeat
    implements ConnectionPool.Heartbeat {
        private final Timer timer;

        private TimerHeartbeat(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void stop() {
            this.timer.cancel();
        }
    }
}

