/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.Log;
import io.ebean.datasource.pool.PooledConnection;
import java.util.Arrays;

final class BusyConnectionBuffer {
    private PooledConnection[] slots;
    private final int growBy;
    private int size;
    private int pos = -1;

    BusyConnectionBuffer(int capacity, int growBy) {
        this.slots = new PooledConnection[capacity];
        this.growBy = growBy;
    }

    void setCapacity(int newCapacity) {
        if (newCapacity > this.slots.length) {
            PooledConnection[] current = this.slots;
            this.slots = new PooledConnection[newCapacity];
            System.arraycopy(current, 0, this.slots, 0, current.length);
        }
    }

    public String toString() {
        return Arrays.toString(this.slots);
    }

    int capacity() {
        return this.slots.length;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    int add(PooledConnection pc) {
        if (this.size == this.slots.length) {
            this.setCapacity(this.slots.length + this.growBy);
        }
        int slot = this.nextEmptySlot();
        pc.setSlotId(slot);
        this.slots[slot] = pc;
        return ++this.size;
    }

    boolean remove(PooledConnection pc) {
        int slotId = pc.slotId();
        if (this.slots[slotId] != pc) {
            PooledConnection heldBy = this.slots[slotId];
            Log.warn("Failed to remove from slot[{0}] PooledConnection[{1}] - HeldBy[{2}]", pc.slotId(), pc, heldBy);
            return false;
        }
        this.slots[slotId] = null;
        --this.size;
        return true;
    }

    void closeBusyConnections(long leakTimeMinutes) {
        long olderThanTime = System.currentTimeMillis() - leakTimeMinutes * 60000L;
        Log.debug("Closing busy connections using leakTimeMinutes {0}", leakTimeMinutes);
        for (int i = 0; i < this.slots.length; ++i) {
            PooledConnection pc;
            if (this.slots[i] == null || (pc = this.slots[i]).lastUsedTime() > olderThanTime) continue;
            this.slots[i] = null;
            --this.size;
            this.closeBusyConnection(pc);
        }
    }

    private void closeBusyConnection(PooledConnection pc) {
        try {
            Log.warn("DataSource closing busy connection? {0}", pc.fullDescription());
            System.out.println("CLOSING busy connection: " + pc.fullDescription());
            pc.closeConnectionFully(false);
        }
        catch (Exception ex) {
            Log.error("Error when closing potentially leaked connection " + pc.description(), ex);
        }
    }

    String busyConnectionInformation(boolean toLogger) {
        if (toLogger) {
            Log.info("Dumping [{0}] busy connections: (Use datasource.xxx.captureStackTrace=true  ... to get stackTraces)", this.size());
        }
        StringBuilder sb = new StringBuilder();
        for (PooledConnection pc : this.slots) {
            if (pc == null) continue;
            if (toLogger) {
                Log.info("Busy Connection - {0}", pc.fullDescription());
                continue;
            }
            sb.append(pc.fullDescription()).append("\r\n");
        }
        return sb.toString();
    }

    private int nextEmptySlot() {
        while (++this.pos < this.slots.length) {
            if (this.slots[this.pos] != null) continue;
            return this.pos;
        }
        this.pos = -1;
        while (++this.pos < this.slots.length) {
            if (this.slots[this.pos] != null) continue;
            return this.pos;
        }
        throw new RuntimeException("No Empty Slot Found?");
    }
}

