/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.core.type;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.UUID;

public final class ScalarTypeUtils {
    private static final char[] ZEROES = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);
    private static final DateTimeFormatter ISO_MILLIS = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant(3).toFormatter();

    public static Instant parseInstant(String jsonDateTime) {
        return Instant.parse(jsonDateTime);
    }

    public static String formatInstant(Instant value) {
        return ISO_MILLIS.format(value);
    }

    public static Duration toDuration(BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = ScalarTypeUtils.extractNanosecondDecimal(value, seconds);
        return Duration.ofSeconds(seconds, nanoseconds);
    }

    public static BigDecimal toDecimal(Duration instant) {
        return new BigDecimal(ScalarTypeUtils.toDecimal(instant.getSeconds(), instant.getNano()));
    }

    public static Timestamp toTimestamp(BigDecimal value) {
        long seconds = value.longValue();
        int nanoseconds = ScalarTypeUtils.extractNanosecondDecimal(value, seconds);
        Timestamp ts = new Timestamp(seconds * 1000L);
        ts.setNanos(nanoseconds);
        return ts;
    }

    public static BigDecimal toDecimal(Timestamp instant) {
        long millis = instant.getTime();
        long secs = millis / 1000L;
        return new BigDecimal(ScalarTypeUtils.toDecimal(secs, instant.getNanos()));
    }

    public static String toDecimal(long seconds, int nanoseconds) {
        StringBuilder string = new StringBuilder(Integer.toString(nanoseconds));
        if (string.length() < 9) {
            string.insert(0, ZEROES, 0, 9 - string.length());
        }
        return seconds + "." + String.valueOf(string);
    }

    private static int extractNanosecondDecimal(BigDecimal value, long integer) {
        return value.subtract(new BigDecimal(integer)).multiply(ONE_BILLION).intValue();
    }

    public static UUID uuidFromBytes(byte[] bytes, boolean optimized) {
        int usableBytes = Math.min(bytes.length, 16);
        byte[] barr = new byte[16];
        int i = 15;
        for (int j = usableBytes - 1; j >= 0; --j) {
            barr[i] = bytes[j];
            --i;
        }
        long msb = optimized ? ((long)barr[4] << 56) + ((long)(barr[5] & 0xFF) << 48) + ((long)(barr[6] & 0xFF) << 40) + ((long)(barr[7] & 0xFF) << 32) + ((long)(barr[2] & 0xFF) << 24) + (long)((barr[3] & 0xFF) << 16) + (long)((barr[0] & 0xFF) << 8) + (long)((barr[1] & 0xFF) << 0) : ((long)barr[0] << 56) + ((long)(barr[1] & 0xFF) << 48) + ((long)(barr[2] & 0xFF) << 40) + ((long)(barr[3] & 0xFF) << 32) + ((long)(barr[4] & 0xFF) << 24) + (long)((barr[5] & 0xFF) << 16) + (long)((barr[6] & 0xFF) << 8) + (long)((barr[7] & 0xFF) << 0);
        long lsb = ((long)barr[8] << 56) + ((long)(barr[9] & 0xFF) << 48) + ((long)(barr[10] & 0xFF) << 40) + ((long)(barr[11] & 0xFF) << 32) + ((long)(barr[12] & 0xFF) << 24) + (long)((barr[13] & 0xFF) << 16) + (long)((barr[14] & 0xFF) << 8) + (long)((barr[15] & 0xFF) << 0);
        return new UUID(msb, lsb);
    }

    public static byte[] uuidToBytes(UUID uuid, boolean optimized) {
        byte[] ret = new byte[16];
        long l = uuid.getMostSignificantBits();
        if (optimized) {
            ret[0] = (byte)(l >>> 8);
            ret[1] = (byte)(l >>> 0);
            ret[2] = (byte)(l >>> 24);
            ret[3] = (byte)(l >>> 16);
            ret[4] = (byte)(l >>> 56);
            ret[5] = (byte)(l >>> 48);
            ret[6] = (byte)(l >>> 40);
            ret[7] = (byte)(l >>> 32);
        } else {
            ret[0] = (byte)(l >>> 56);
            ret[1] = (byte)(l >>> 48);
            ret[2] = (byte)(l >>> 40);
            ret[3] = (byte)(l >>> 32);
            ret[4] = (byte)(l >>> 24);
            ret[5] = (byte)(l >>> 16);
            ret[6] = (byte)(l >>> 8);
            ret[7] = (byte)(l >>> 0);
        }
        l = uuid.getLeastSignificantBits();
        ret[8] = (byte)(l >>> 56);
        ret[9] = (byte)(l >>> 48);
        ret[10] = (byte)(l >>> 40);
        ret[11] = (byte)(l >>> 32);
        ret[12] = (byte)(l >>> 24);
        ret[13] = (byte)(l >>> 16);
        ret[14] = (byte)(l >>> 8);
        ret[15] = (byte)(l >>> 0);
        return ret;
    }
}

