/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.core.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.config.JsonConfig;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;

public abstract class ScalarTypeBaseDate<T>
extends ScalarTypeBase<T> {
    protected final JsonConfig.Date mode;

    public ScalarTypeBaseDate(JsonConfig.Date mode, Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
        this.mode = mode;
    }

    protected abstract String toIsoFormat(T var1);

    public abstract long convertToMillis(T var1);

    public abstract Date convertToDate(T var1);

    public abstract T convertFromDate(Date var1);

    @Override
    public void bind(DataBinder binder, T value) throws SQLException {
        if (value == null) {
            binder.setNull(91);
        } else {
            binder.setDate(this.convertToDate(value));
        }
    }

    @Override
    public T read(DataReader reader) throws SQLException {
        Date date = reader.getDate();
        return date == null ? null : (T)this.convertFromDate(date);
    }

    @Override
    public String formatValue(T value) {
        Date date = this.convertToDate(value);
        return Long.toString(date.getTime());
    }

    @Override
    public T parse(String value) {
        try {
            return this.convertFromDate(new Date(Long.parseLong(value)));
        }
        catch (NumberFormatException e) {
            return this.convertFromDate(Date.valueOf(value));
        }
    }

    public T convertFromMillis(long systemTimeMillis) {
        return this.convertFromDate(new Date(systemTimeMillis));
    }

    @Override
    public T jsonRead(JsonParser parser) throws IOException {
        if (JsonToken.VALUE_NUMBER_INT == parser.getCurrentToken()) {
            return this.convertFromMillis(parser.getLongValue());
        }
        return this.convertFromDate(Date.valueOf(parser.getText()));
    }

    @Override
    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        if (this.mode == JsonConfig.Date.ISO8601) {
            writer.writeString(this.toIsoFormat(value));
        } else {
            writer.writeNumber(this.convertToMillis(value));
        }
    }

    @Override
    public DocPropertyType docType() {
        return DocPropertyType.DATE;
    }

    @Override
    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.convertFromDate(new Date(dataInput.readLong()));
    }

    @Override
    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeLong(this.convertToDate(value).getTime());
        }
    }
}

