/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import io.ebean.text.TextException;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

final class ScalarTypeByte
extends ScalarTypeBase<Byte> {
    public ScalarTypeByte() {
        super(Byte.class, true, -6);
    }

    public boolean binary() {
        return true;
    }

    public void bind(DataBinder binder, Byte value) throws SQLException {
        if (value == null) {
            binder.setNull(-6);
        } else {
            binder.setByte(value.byteValue());
        }
    }

    public Byte read(DataReader reader) throws SQLException {
        return reader.getByte();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toByte((Object)value);
    }

    public Byte toBeanType(Object value) {
        return BasicTypeConverter.toByte((Object)value);
    }

    public void jsonWrite(JsonGenerator writer, Byte value) throws IOException {
        writer.writeBinary(new byte[]{value});
    }

    public Byte jsonRead(JsonParser parser) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        parser.readBinaryValue((OutputStream)os);
        byte[] bytes = os.toByteArray();
        if (bytes.length == 0) {
            return null;
        }
        return bytes[0];
    }

    public DocPropertyType docType() {
        return DocPropertyType.BINARY;
    }

    public String formatValue(Byte t) {
        return t.toString();
    }

    public Byte parse(String value) {
        throw new TextException("Not supported");
    }

    public Byte readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readByte();
    }

    public void writeData(DataOutput dataOutput, Byte val) throws IOException {
        if (val == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeByte(val.byteValue());
        }
    }
}

