/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class RsetDataReader
implements DataReader {
    private static final int bufferSize = 512;
    static final int clobBufferSize = 512;
    static final int stringInitialSize = 512;
    private final boolean unmodifiable;
    private final DataTimeZone dataTimeZone;
    private final ResultSet rset;
    protected int pos;
    private String json;

    public RsetDataReader(boolean unmodifiable, DataTimeZone dataTimeZone, ResultSet rset) {
        this.unmodifiable = unmodifiable;
        this.dataTimeZone = dataTimeZone;
        this.rset = rset;
    }

    public boolean unmodifiable() {
        return this.unmodifiable;
    }

    public final void pushJson(String json) {
        this.json = json;
    }

    public final String popJson() {
        return this.json;
    }

    public final void close() throws SQLException {
        this.rset.close();
    }

    public final boolean next() throws SQLException {
        this.pos = 0;
        return this.rset.next();
    }

    public final void incrementPos(int increment) {
        this.pos += increment;
    }

    protected int pos() {
        return ++this.pos;
    }

    public final Array getArray() throws SQLException {
        return this.rset.getArray(this.pos());
    }

    public final Object getObject() throws SQLException {
        return this.rset.getObject(this.pos());
    }

    public final <T> T getObject(Class<T> cls) throws SQLException {
        return this.rset.getObject(this.pos(), cls);
    }

    public final BigDecimal getBigDecimal() throws SQLException {
        return this.rset.getBigDecimal(this.pos());
    }

    public final InputStream getBinaryStream() throws SQLException {
        return this.rset.getBinaryStream(this.pos());
    }

    public final Boolean getBoolean() throws SQLException {
        boolean v = this.rset.getBoolean(this.pos());
        return this.rset.wasNull() ? null : Boolean.valueOf(v);
    }

    public final Byte getByte() throws SQLException {
        byte v = this.rset.getByte(this.pos());
        return this.rset.wasNull() ? null : Byte.valueOf(v);
    }

    public final byte[] getBytes() throws SQLException {
        return this.rset.getBytes(this.pos());
    }

    public final Date getDate() throws SQLException {
        Calendar cal = this.dataTimeZone.getTimeComponentTimeZone();
        if (cal != null) {
            return this.rset.getDate(this.pos(), cal);
        }
        return this.rset.getDate(this.pos());
    }

    public final Double getDouble() throws SQLException {
        double v = this.rset.getDouble(this.pos());
        return this.rset.wasNull() ? null : Double.valueOf(v);
    }

    public final Float getFloat() throws SQLException {
        float v = this.rset.getFloat(this.pos());
        return this.rset.wasNull() ? null : Float.valueOf(v);
    }

    public final Integer getInt() throws SQLException {
        int v = this.rset.getInt(this.pos());
        return this.rset.wasNull() ? null : Integer.valueOf(v);
    }

    public final Long getLong() throws SQLException {
        long v = this.rset.getLong(this.pos());
        return this.rset.wasNull() ? null : Long.valueOf(v);
    }

    public final Ref getRef() throws SQLException {
        return this.rset.getRef(this.pos());
    }

    public final Short getShort() throws SQLException {
        short s = this.rset.getShort(this.pos());
        return this.rset.wasNull() ? null : Short.valueOf(s);
    }

    public final String getString() throws SQLException {
        return this.rset.getString(this.pos());
    }

    public final Time getTime() throws SQLException {
        Calendar cal = this.dataTimeZone.getTimeComponentTimeZone();
        if (cal != null) {
            return this.rset.getTime(this.pos(), cal);
        }
        return this.rset.getTime(this.pos());
    }

    public final Timestamp getTimestamp() throws SQLException {
        Calendar cal = this.dataTimeZone.getTimeZone();
        if (cal != null) {
            return this.rset.getTimestamp(this.pos(), cal);
        }
        return this.rset.getTimestamp(this.pos());
    }

    public final String getStringFromStream() throws SQLException {
        Reader reader = this.rset.getCharacterStream(this.pos());
        return reader == null ? null : this.readStringLob(reader);
    }

    private String readStringLob(Reader reader) throws SQLException {
        char[] buffer = new char[512];
        StringBuilder out = new StringBuilder(512);
        try {
            int readLength;
            while ((readLength = reader.read(buffer)) != -1) {
                out.append(buffer, 0, readLength);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new SQLException("IOException reading Clob " + e.getMessage());
        }
        return out.toString();
    }

    public final byte[] getBinaryBytes() throws SQLException {
        InputStream in = this.rset.getBinaryStream(this.pos());
        return this.getBinaryLob(in);
    }

    private byte[] getBinaryLob(InputStream in) throws SQLException {
        byte[] byArray;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buf = new byte[512];
            while ((len = in.read(buf, 0, buf.length)) != -1) {
                out.write(buf, 0, len);
            }
            byte[] data = out.toByteArray();
            if (data.length == 0) {
                data = null;
            }
            in.close();
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SQLException(e.getClass().getName() + ":" + e.getMessage());
            }
        }
        out.close();
        return byArray;
    }
}

