/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.type.EnumToDbValueMap;
import jakarta.persistence.PersistenceException;
import java.sql.SQLException;

final class EnumToDbIntegerMap
extends EnumToDbValueMap<Integer> {
    @Override
    public int getDbType() {
        return 4;
    }

    public EnumToDbIntegerMap() {
        this(true);
    }

    public EnumToDbIntegerMap(boolean allowNulls) {
        super(allowNulls, true);
    }

    public void add(Object beanValue, Integer dbValue, String name) {
        this.addInternal(beanValue, dbValue, name);
    }

    @Override
    public Object getBeanValue(Object dbValue) {
        if (dbValue instanceof String) {
            return super.getBeanValue(Integer.parseInt(dbValue.toString()));
        }
        return super.getBeanValue(dbValue);
    }

    public EnumToDbIntegerMap add(Object beanValue, String stringDbValue, String name) {
        try {
            Integer value = Integer.valueOf(stringDbValue);
            this.addInternal(beanValue, value, name);
            return this;
        }
        catch (Exception e) {
            throw new PersistenceException("Error converted enum [" + beanValue.getClass().getName() + "] value[" + String.valueOf(beanValue) + "] string value [" + stringDbValue + "] to an Integer.", (Throwable)e);
        }
    }

    @Override
    public void bind(DataBinder binder, Object value) throws SQLException {
        if (value == null) {
            binder.setNull(4);
        } else {
            Integer s = (Integer)this.getDbValue(value);
            binder.setInt(s.intValue());
        }
    }

    @Override
    public Object read(DataReader reader) throws SQLException {
        Integer i = reader.getInt();
        if (i == null) {
            return null;
        }
        return this.getBeanValue(i);
    }
}

