/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.ImplicitReadOnlyTransaction;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

class TransactionFactoryBasic
extends TransactionFactory {
    protected final DataSource dataSource;

    TransactionFactoryBasic(TransactionManager manager, DataSourceSupplier dataSourceSupplier) {
        super(manager);
        this.dataSource = dataSourceSupplier.dataSource();
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId, boolean useMaster) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            return new ImplicitReadOnlyTransaction(true, this.manager, connection);
        }
        catch (PersistenceException ex) {
            JdbcClose.close((Connection)connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    @Override
    public final SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            SpiTransaction t = this.createTransaction(explicit, connection);
            return this.setIsolationLevel(t, isolationLevel);
        }
        catch (PersistenceException ex) {
            JdbcClose.close((Connection)connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }
}

