/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;
import io.ebean.TransactionCallback;
import io.ebean.event.changelog.BeanChange;
import io.ebean.event.changelog.ChangeSet;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiPersistenceContext;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTxnLogger;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TxnProfileEventCodes;
import io.ebeaninternal.server.core.PersistDeferredRelationship;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import io.ebeaninternal.server.transaction.ProfileStream;
import io.ebeaninternal.server.transaction.TransactionManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

final class ImplicitReadOnlyTransaction
implements SpiTransaction,
TxnProfileEventCodes {
    private static final String illegalStateMessage = "Transaction is Inactive";
    private static final String notExpectedMessage = "Not expected on read only transaction";
    private boolean useCommit;
    private final TransactionManager manager;
    private final SpiTxnLogger logger;
    private final boolean logSql;
    private final boolean logSummary;
    private boolean active;
    private Connection connection;
    private SpiPersistenceContext persistenceContext;
    private Object tenantId;
    private Map<String, Object> userObjects;
    private final Instant startTime = Instant.now();
    private final long startNanos;
    private ProfileLocation profileLocation;

    ImplicitReadOnlyTransaction(boolean useCommit, TransactionManager manager, Connection connection) {
        this.manager = manager;
        this.logger = manager.loggerReadOnly();
        this.logSql = this.logger.isLogSql();
        this.logSummary = this.logger.isLogSummary();
        this.active = true;
        this.connection = connection;
        this.persistenceContext = new DefaultPersistenceContext();
        this.startNanos = System.nanoTime();
        try {
            this.useCommit = useCommit && !connection.getAutoCommit();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    ImplicitReadOnlyTransaction(TransactionManager manager, Connection connection, Object tenantId) {
        this(true, manager, connection);
        this.tenantId = tenantId;
    }

    @Override
    public Instant startTime() {
        return this.startTime;
    }

    public void setAutoPersistUpdates(boolean autoPersistUpdates) {
    }

    @Override
    public boolean isAutoPersistUpdates() {
        return false;
    }

    public void setLabel(String label) {
    }

    @Override
    public String label() {
        return null;
    }

    @Override
    public long profileOffset() {
        return 0L;
    }

    @Override
    public void profileEvent(SpiProfileTransactionEvent event) {
    }

    @Override
    public void setProfileStream(ProfileStream profileStream) {
    }

    @Override
    public ProfileStream profileStream() {
        return null;
    }

    @Override
    public void setProfileLocation(ProfileLocation profileLocation) {
        this.profileLocation = profileLocation;
    }

    @Override
    public ProfileLocation profileLocation() {
        return this.profileLocation;
    }

    public boolean isSkipCache() {
        return false;
    }

    @Override
    public boolean isSkipCacheExplicit() {
        return false;
    }

    public void setSkipCache(boolean skipCache) {
    }

    @Override
    public void addBeanChange(BeanChange beanChange) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void sendChangeLog(ChangeSet changesRequest) {
        throw new IllegalStateException(notExpectedMessage);
    }

    public void register(TransactionCallback callback) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void registerDeferred(PersistDeferredRelationship derived) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void registerDeleteBean(Class<?> type, Object id) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isRegisteredDeleteBean(Class<?> type, Object id) {
        return false;
    }

    @Override
    public void unregisterBeans() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        return false;
    }

    @Override
    public boolean isSaveAssocManyIntersection(String intersectionTable, String beanName) {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void markNotQueryOnly() {
    }

    @Override
    public boolean isNestedUseSavepoint() {
        return false;
    }

    public void setNestedUseSavepoint() {
    }

    public boolean isReadOnly() {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void setUpdateAllLoadedProperties(boolean updateAllLoadedProperties) {
    }

    @Override
    public Boolean isUpdateAllLoadedProperties() {
        return null;
    }

    public void setBatchMode(boolean batchMode) {
    }

    public boolean isBatchMode() {
        return false;
    }

    public boolean isBatchOnCascade() {
        return false;
    }

    public void setBatchOnCascade(boolean batchMode) {
    }

    @Override
    public Boolean getBatchGetGeneratedKeys() {
        return null;
    }

    public void setGetGeneratedKeys(boolean getGeneratedKeys) {
    }

    public void setFlushOnMixed(boolean batchFlushOnMixed) {
    }

    @Override
    public int getBatchSize() {
        return 0;
    }

    public void setBatchSize(int batchSize) {
    }

    public boolean isFlushOnQuery() {
        return false;
    }

    public void setFlushOnQuery(boolean batchFlushOnQuery) {
    }

    @Override
    public boolean isBatchThisRequest() {
        return false;
    }

    @Override
    public void checkBatchEscalationOnCollection() {
    }

    @Override
    public void flushBatchOnCollection() {
    }

    @Override
    public PersistenceException translate(String message, SQLException cause) {
        return new PersistenceException(message, (Throwable)cause);
    }

    @Override
    public void flushBatchOnCascade() {
    }

    @Override
    public void flushBatchOnRollback() {
    }

    @Override
    public boolean checkBatchEscalationOnCascade(PersistRequestBean<?> request) {
        return false;
    }

    @Override
    public BatchControl batchControl() {
        return null;
    }

    @Override
    public void setBatchControl(BatchControl batchControl) {
    }

    public void flush() {
    }

    @Override
    public SpiPersistenceContext persistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(SpiPersistenceContext context) {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.persistenceContext = context;
    }

    @Override
    public TransactionEvent event() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public boolean isExplicit() {
        return false;
    }

    @Override
    public boolean isLogSql() {
        return this.logSql;
    }

    @Override
    public boolean isLogSummary() {
        return this.logSummary;
    }

    @Override
    public void logSql(String msg, Object ... args) {
        this.logger.sql(msg, args);
    }

    @Override
    public void logSummary(String msg, Object ... args) {
        this.logger.sum(msg, args);
    }

    @Override
    public void logTxn(String msg, Object ... args) {
    }

    @Override
    public String id() {
        return null;
    }

    @Override
    public void setTenantId(Object tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Object tenantId() {
        return this.tenantId;
    }

    @Override
    public Connection internalConnection() {
        if (!this.active) {
            throw new IllegalStateException(illegalStateMessage);
        }
        return this.connection;
    }

    public Connection connection() {
        return this.internalConnection();
    }

    private void deactivate() {
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            CoreLog.log.log(System.Logger.Level.ERROR, "Error closing connection", (Throwable)ex);
        }
        this.connection = null;
        this.active = false;
        this.manager.collectMetricReadOnly((System.nanoTime() - this.startNanos) / 1000L);
    }

    public void commitAndContinue() {
    }

    public void commit() {
        block6: {
            if (!this.active) {
                throw new IllegalStateException(illegalStateMessage);
            }
            try {
                if (!this.useCommit) break block6;
                try {
                    this.connection.commit();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            finally {
                this.deactivate();
            }
        }
    }

    public boolean isRollbackOnly() {
        return false;
    }

    public void setRollbackOnly() {
        throw new IllegalStateException(notExpectedMessage);
    }

    @Override
    public void setAutoCommitOnFindIterate() {
        try {
            this.connection.setAutoCommit(false);
            this.useCommit = true;
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void rollbackAndContinue() {
    }

    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    public void rollback(Throwable cause) throws PersistenceException {
        block6: {
            if (!this.active) {
                throw new IllegalStateException(illegalStateMessage);
            }
            try {
                if (!this.useCommit) break block6;
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
            finally {
                this.deactivate();
            }
        }
    }

    public void end() throws PersistenceException {
        if (this.active) {
            this.rollback();
        }
    }

    @Override
    public void preCommit() {
    }

    @Override
    public void postCommit() {
    }

    @Override
    public void postRollback(Throwable cause) {
    }

    @Override
    public void deactivateExternal() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPersistCascade() {
        return false;
    }

    public void setPersistCascade(boolean persistCascade) {
    }

    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        throw new IllegalStateException(notExpectedMessage);
    }

    public void putUserObject(String name, Object value) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<String, Object>();
        }
        this.userObjects.put(name, value);
    }

    public Object getUserObject(String name) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.get(name);
    }

    public void close() {
        this.end();
    }
}

