/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.CancelableQuery;
import io.ebeaninternal.api.SpiCancelableQuery;
import jakarta.persistence.PersistenceException;
import java.util.concurrent.locks.ReentrantLock;

public class AbstractQuery
implements SpiCancelableQuery {
    private final ReentrantLock lock = new ReentrantLock();
    private boolean cancelled;
    private CancelableQuery cancelableQuery;
    protected boolean useMaster;

    public final void cancel() {
        this.lock.lock();
        try {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.cancelableQuery != null) {
                    this.cancelableQuery.cancel();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void checkCancelled() {
        if (this.cancelled) {
            throw new PersistenceException("Query was cancelled");
        }
    }

    @Override
    public final void setCancelableQuery(CancelableQuery cancelableQuery) {
        this.lock.lock();
        try {
            this.checkCancelled();
            this.cancelableQuery = cancelableQuery;
        }
        finally {
            this.lock.unlock();
        }
    }
}

