/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.persist.MergeNode;
import io.ebeaninternal.server.persist.MergeRequest;
import java.util.Objects;

final class MergeNodeAssocOne
extends MergeNode {
    private final BeanPropertyAssocOne<?> one;

    MergeNodeAssocOne(String fullPath, BeanPropertyAssocOne<?> property) {
        super(fullPath, property);
        this.one = property;
    }

    @Override
    public void merge(MergeRequest request) {
        EntityBean entityBean = this.getEntityBean(request.getBean());
        if (entityBean == null) {
            this.checkOrphanRemoval(request);
        } else {
            Object beanId = this.targetDescriptor.getId(entityBean);
            if (beanId == null) {
                this.checkOrphanRemoval(request);
            } else {
                Object outlineId;
                EntityBean outlineBean = this.getEntityBean(request.getOutline());
                Object object = outlineId = outlineBean == null ? null : this.targetDescriptor.getId(outlineBean);
                if (this.isUpdate(beanId, outlineId, request)) {
                    entityBean._ebean_getIntercept().setForceUpdate(true);
                    this.cascade(entityBean, outlineBean, request);
                }
            }
        }
    }

    private void checkOrphanRemoval(MergeRequest request) {
        EntityBean outlineBean;
        if (this.one.isOrphanRemoval() && (outlineBean = this.getEntityBean(request.getOutline())) != null) {
            request.addDelete(outlineBean);
        }
    }

    private boolean isUpdate(Object beanId, Object outlineId, MergeRequest request) {
        return Objects.equals(beanId, outlineId) || !request.isClientGeneratedIds() || request.idExists(this.targetDescriptor.type(), beanId);
    }

    private EntityBean getEntityBean(Object bean) {
        return (EntityBean)this.one.getValue((EntityBean)bean);
    }
}

